/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.security.acl.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.servicemix.jbi.security.GroupPrincipal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizationEntry {
    public static final String TYPE_ADD = "add";
    public static final String TYPE_SET = "set";
    public static final String TYPE_REM = "rem";
    private Set<GroupPrincipal> acls;
    private QName service;
    private String endpoint;
    private QName operation;
    private String type = "add";

    public AuthorizationEntry() {
    }

    public AuthorizationEntry(QName service, String endpoint, QName operation, String roles) {
        this.service = service;
        this.endpoint = endpoint;
        this.operation = operation;
        this.setRoles(roles);
    }

    public AuthorizationEntry(QName service, String endpoint, QName operation, String roles, String type) {
        this.service = service;
        this.endpoint = endpoint;
        this.operation = operation;
        this.setRoles(roles);
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public QName getService() {
        return this.service;
    }

    public void setService(QName service) {
        if ("".equals(service.getNamespaceURI()) && service.getPrefix() != null && service.getPrefix().length() > 0) {
            service = new QName(service.getPrefix(), service.getLocalPart());
        }
        this.service = service;
    }

    public QName getOperation() {
        return this.operation;
    }

    public void setOperation(QName operation) {
        this.operation = operation;
    }

    public Set<GroupPrincipal> getAcls() {
        return this.acls;
    }

    public void setAcls(Set<GroupPrincipal> acls) {
        this.acls = acls;
    }

    public void setRoles(String roles) {
        this.acls = new HashSet<GroupPrincipal>();
        StringTokenizer iter = new StringTokenizer(roles, ",");
        while (iter.hasMoreTokens()) {
            String name = iter.nextToken().trim();
            this.acls.add(new GroupPrincipal(name));
        }
    }

    public String getRoles() {
        StringBuffer sb = new StringBuffer();
        if (this.acls != null) {
            Iterator<GroupPrincipal> iter = this.acls.iterator();
            while (iter.hasNext()) {
                GroupPrincipal p = iter.next();
                sb.append(p);
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
        }
        return sb.toString();
    }

    public String toString() {
        return "AuthorizationEntry[service=" + this.service + ", endpoint=" + this.endpoint + ", roles=" + this.getRoles() + "]";
    }
}

