/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.view;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.container.JBIContainer;
import org.apache.servicemix.jbi.event.ContainerAware;
import org.apache.servicemix.jbi.framework.ComponentMBeanImpl;
import org.apache.servicemix.jbi.framework.Endpoint;
import org.apache.servicemix.jbi.framework.Registry;
import org.apache.servicemix.jbi.view.EndpointViewRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DotViewEndpointListener
extends EndpointViewRenderer
implements ContainerAware {
    private static final Log log = LogFactory.getLog(DotViewEndpointListener.class);
    private JBIContainer container;
    private String file = "ServiceMixComponents.dot";

    public JBIContainer getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(JBIContainer container) {
        this.container = container;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRender() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating DOT file at: " + this.file));
        }
        PrintWriter writer = new PrintWriter(new FileWriter(this.file));
        try {
            this.generateFile(writer);
        }
        finally {
            writer.close();
        }
    }

    protected void generateFile(PrintWriter writer) throws Exception {
        writer.println("digraph \"Apache ServiceMix\" {");
        writer.println();
        writer.println("node [ shape = box, style = \"rounded,filled\", fontname = \"Helvetica-Oblique\", fontsize = 8 ];");
        writer.println();
        writer.println("jbi [ fillcolor = \"#FFFF99\", label=\"Apache ServiceMix: " + this.container.getName() + "\" ];");
        writer.println();
        ArrayList<String> brokerLinks = new ArrayList<String>();
        Registry registry = this.container.getRegistry();
        Collection<ComponentMBeanImpl> components = registry.getComponents();
        for (ComponentMBeanImpl component : components) {
            String name = component.getName();
            String id = this.encode(name);
            writer.print(id);
            writer.print(" [ fillcolor = gray, label = \"");
            writer.print(name);
            writer.println("\" ];");
            brokerLinks.add("jbi -> " + id);
        }
        writer.println();
        this.generateLinks(writer, brokerLinks);
        writer.println();
        ArrayList<String> componentEndpointLinks = new ArrayList<String>();
        Collection<Endpoint> endpointMBeans = registry.getEndpointRegistry().getEndpointMBeans();
        for (Endpoint endpoint : endpointMBeans) {
            String key = endpoint.getSubType().toLowerCase() + ":{" + endpoint.getServiceName().getNamespaceURI() + "}" + endpoint.getServiceName().getLocalPart() + ":" + endpoint.getEndpointName();
            String componentName = this.encode(endpoint.getComponentName());
            String id = this.encode(key);
            writer.print(id);
            String epname = this.formatEndpoint(key);
            String color = "lightgray";
            if (epname.startsWith("internal")) {
                epname = epname.substring(10);
                color = "#6699ff";
            } else if (epname.startsWith("external")) {
                epname = epname.substring(10);
                color = "#66ccff";
            } else if (epname.startsWith("dynamic")) {
                epname = epname.substring(9);
                color = "#6666ff";
            } else if (epname.startsWith("linked")) {
                epname = epname.substring(8);
                color = "#66ffff";
            } else {
                color = "#f3f3f3";
            }
            writer.print(" [ fillcolor = \"" + color + "\", label = \"");
            writer.print(epname);
            writer.println("\" ];");
            componentEndpointLinks.add(componentName + " -> " + id);
        }
        this.generateLinks(writer, componentEndpointLinks);
        writer.println("}");
    }

    protected String formatEndpoint(String key) {
        int i1 = key.indexOf(123);
        int i2 = key.indexOf(125);
        int i3 = key.indexOf(58, i2);
        String type = key.charAt(i1 - 1) == ':' ? key.substring(0, i1 - 1) : null;
        String uri = key.substring(i1 + 1, i2);
        String svc = key.substring(i2 + 1, i3);
        String ep = key.substring(i3 + 1);
        if (type != null) {
            return type + "\\n" + uri + "\\n" + svc + "\\n" + ep;
        }
        return uri + "\\n" + svc + "\\n" + ep;
    }

    protected void generateLinks(PrintWriter writer, Collection<String> lines, String style) {
        for (String line : lines) {
            writer.print(line);
            if (style != null) {
                writer.print(" [" + style + "]");
            }
            writer.println(";");
        }
        writer.println();
    }

    protected void generateLinks(PrintWriter writer, Collection<String> lines) {
        this.generateLinks(writer, lines, null);
    }

    protected String encode(String name) {
        StringBuffer buffer = new StringBuffer();
        int size = name.length();
        for (int i = 0; i < size; ++i) {
            char ch = name.charAt(i);
            if (Character.isLetterOrDigit(ch) || ch == '_') {
                buffer.append(ch);
                continue;
            }
            buffer.append('_');
        }
        return buffer.toString();
    }
}

