/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.view;

import javax.jbi.servicedesc.ServiceEndpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.event.EndpointEvent;
import org.apache.servicemix.jbi.event.EndpointListener;

public abstract class EndpointViewRenderer
implements EndpointListener {
    private static final Log log = LogFactory.getLog(EndpointViewRenderer.class);
    private boolean dirty;
    private boolean rerenderOnChange = true;

    public void render() throws Exception {
        this.doRender();
        this.dirty = false;
    }

    public void internalEndpointRegistered(EndpointEvent event) {
        this.viewIsDirty(event.getEndpoint());
    }

    public void internalEndpointUnregistered(EndpointEvent event) {
        this.viewIsDirty(event.getEndpoint());
    }

    public void externalEndpointRegistered(EndpointEvent event) {
        this.viewIsDirty(event.getEndpoint());
    }

    public void externalEndpointUnregistered(EndpointEvent event) {
        this.viewIsDirty(event.getEndpoint());
    }

    public void linkedEndpointRegistered(EndpointEvent event) {
        this.viewIsDirty(event.getEndpoint());
    }

    public void linkedEndpointUnregistered(EndpointEvent event) {
        this.viewIsDirty(event.getEndpoint());
    }

    public void remoteEndpointRegistered(EndpointEvent event) {
        this.viewIsDirty(event.getEndpoint());
    }

    public void remoteEndpointUnregistered(EndpointEvent event) {
        this.viewIsDirty(event.getEndpoint());
    }

    public boolean isRerenderOnChange() {
        return this.rerenderOnChange;
    }

    public void setRerenderOnChange(boolean rerenderOnChange) {
        this.rerenderOnChange = rerenderOnChange;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    protected abstract void doRender() throws Exception;

    protected void viewIsDirty(ServiceEndpoint endpoint) {
        this.dirty = true;
        if (this.rerenderOnChange) {
            try {
                this.render();
            }
            catch (Exception e) {
                log.warn((Object)("Failed to render view: " + e), (Throwable)e);
            }
        }
    }
}

