/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import org.springframework.core.Constants;
import org.springframework.jdbc.datasource.UserCredentialsDataSourceAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class IsolationLevelDataSourceAdapter
extends UserCredentialsDataSourceAdapter {
    private static final Constants constants = new Constants(class$org$springframework$transaction$TransactionDefinition == null ? (class$org$springframework$transaction$TransactionDefinition = IsolationLevelDataSourceAdapter.class$("org.springframework.transaction.TransactionDefinition")) : class$org$springframework$transaction$TransactionDefinition);
    private Integer isolationLevel;
    static /* synthetic */ Class class$org$springframework$transaction$TransactionDefinition;

    public final void setIsolationLevelName(String constantName) throws IllegalArgumentException {
        if (constantName == null || !constantName.startsWith("ISOLATION_")) {
            throw new IllegalArgumentException("Only isolation constants allowed");
        }
        this.setIsolationLevel(constants.asNumber(constantName).intValue());
    }

    public void setIsolationLevel(int isolationLevel) {
        if (!constants.getValues("ISOLATION_").contains(new Integer(isolationLevel))) {
            throw new IllegalArgumentException("Only values of isolation constants allowed");
        }
        this.isolationLevel = isolationLevel != -1 ? new Integer(isolationLevel) : null;
    }

    protected Integer getIsolationLevel() {
        return this.isolationLevel;
    }

    protected Connection doGetConnection(String username, String password) throws SQLException {
        Integer isolationLevelToUse;
        Connection con = super.doGetConnection(username, password);
        Boolean readOnlyToUse = this.getCurrentReadOnlyFlag();
        if (readOnlyToUse != null) {
            con.setReadOnly(readOnlyToUse);
        }
        if ((isolationLevelToUse = this.getCurrentIsolationLevel()) != null) {
            con.setTransactionIsolation(isolationLevelToUse);
        }
        return con;
    }

    protected Integer getCurrentIsolationLevel() {
        Integer isolationLevelToUse = TransactionSynchronizationManager.getCurrentTransactionIsolationLevel();
        if (isolationLevelToUse == null) {
            isolationLevelToUse = this.getIsolationLevel();
        }
        return isolationLevelToUse;
    }

    protected Boolean getCurrentReadOnlyFlag() {
        boolean txReadOnly = TransactionSynchronizationManager.isCurrentTransactionReadOnly();
        return txReadOnly ? Boolean.TRUE : null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

