/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import org.apache.camel.Component;
import org.apache.camel.component.bean.BeanComponent;
import org.apache.camel.component.event.EventComponent;
import org.apache.camel.component.event.EventEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.spi.Injector;
import org.apache.camel.spring.spi.SpringComponentResolver;
import org.apache.camel.spring.spi.SpringInjector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.AbstractRefreshableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringCamelContext
extends DefaultCamelContext
implements InitializingBean,
DisposableBean,
ApplicationContextAware,
ApplicationListener {
    private static final transient Log log = LogFactory.getLog(SpringCamelContext.class);
    private ApplicationContext applicationContext;
    private EventEndpoint eventEndpoint;

    public SpringCamelContext() {
    }

    public SpringCamelContext(ApplicationContext applicationContext) {
        this.setApplicationContext(applicationContext);
    }

    public static SpringCamelContext springCamelContext(ApplicationContext applicationContext) throws Exception {
        String[] names = applicationContext.getBeanNamesForType(SpringCamelContext.class);
        if (names.length == 1) {
            return (SpringCamelContext)((Object)applicationContext.getBean(names[0], SpringCamelContext.class));
        }
        SpringCamelContext answer = new SpringCamelContext();
        answer.setApplicationContext(applicationContext);
        answer.afterPropertiesSet();
        return answer;
    }

    public static SpringCamelContext springCamelContext(String configLocations) throws Exception {
        return SpringCamelContext.springCamelContext((ApplicationContext)new ClassPathXmlApplicationContext(configLocations));
    }

    public void afterPropertiesSet() throws Exception {
        if (this.eventEndpoint == null) {
            this.eventEndpoint = this.createEventEndpoint();
        }
        this.getInjector();
        this.start();
    }

    public void destroy() throws Exception {
        this.stop();
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (this.eventEndpoint != null) {
            this.eventEndpoint.onApplicationEvent(event);
        } else {
            log.warn((Object)("No eventEndpoint enabled for event: " + event));
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.addComponent("bean", (Component)new BeanComponent(applicationContext));
        if (applicationContext instanceof ConfigurableApplicationContext) {
            this.addComponent("event", (Component)new EventComponent(applicationContext));
        }
    }

    public EventEndpoint getEventEndpoint() {
        return this.eventEndpoint;
    }

    public void setEventEndpoint(EventEndpoint eventEndpoint) {
        this.eventEndpoint = eventEndpoint;
    }

    protected Injector createInjector() {
        return new SpringInjector((AbstractRefreshableApplicationContext)this.getApplicationContext());
    }

    protected ComponentResolver createComponentResolver() {
        ComponentResolver defaultResolver = super.createComponentResolver();
        return new SpringComponentResolver(this.getApplicationContext(), defaultResolver);
    }

    protected EventEndpoint createEventEndpoint() {
        EventEndpoint endpoint = (EventEndpoint)this.getEndpoint("event:default", EventEndpoint.class);
        return endpoint;
    }
}

