/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.spi;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.camel.spi.Policy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringTransactionPolicy<E>
implements Policy<E> {
    private static final transient Log log = LogFactory.getLog(SpringTransactionPolicy.class);
    private TransactionTemplate template;

    public SpringTransactionPolicy() {
    }

    public SpringTransactionPolicy(TransactionTemplate template) {
        this.template = template;
    }

    public Processor wrap(Processor processor) {
        final TransactionTemplate transactionTemplate = this.getTemplate();
        if (transactionTemplate == null) {
            log.warn((Object)"No TransactionTemplate available so transactions will not be enabled!");
            return processor;
        }
        return new DelegateProcessor(processor){

            public void process(final Exchange exchange) {
                transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                    protected void doInTransactionWithoutResult(TransactionStatus status) {
                        try {
                            this.processNext(exchange);
                        }
                        catch (Exception e) {
                            throw new RuntimeCamelException((Throwable)e);
                        }
                    }
                });
            }

            public String toString() {
                return "SpringTransactionPolicy:" + this.propagationBehaviorToString(transactionTemplate.getPropagationBehavior()) + "[" + this.getProcessor() + "]";
            }

            private String propagationBehaviorToString(int propagationBehavior) {
                switch (propagationBehavior) {
                    case 2: {
                        return "PROPAGATION_MANDATORY";
                    }
                    case 6: {
                        return "PROPAGATION_NESTED";
                    }
                    case 5: {
                        return "PROPAGATION_NEVER";
                    }
                    case 4: {
                        return "PROPAGATION_NOT_SUPPORTED";
                    }
                    case 0: {
                        return "PROPAGATION_REQUIRED";
                    }
                    case 3: {
                        return "PROPAGATION_REQUIRES_NEW";
                    }
                    case 1: {
                        return "PROPAGATION_SUPPORTS";
                    }
                }
                return "UNKOWN";
            }
        };
    }

    public TransactionTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(TransactionTemplate template) {
        this.template = template;
    }
}

