/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.builder.FromBuilder;
import org.apache.camel.processor.Aggregator;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;

public class AggregatorBuilder
extends FromBuilder {
    private final Expression correlationExpression;
    private long batchTimeout = 1000L;
    private int batchSize = 50000;
    private AggregationStrategy aggregationStrategy = new UseLatestAggregationStrategy();

    public AggregatorBuilder(FromBuilder builder, Expression correlationExpression) {
        super(builder);
        this.correlationExpression = correlationExpression;
    }

    public Route createRoute() throws Exception {
        final Processor processor = super.createProcessor();
        final Aggregator service = new Aggregator(this.getFrom(), processor, this.correlationExpression, this.aggregationStrategy);
        return new Route<Exchange>(this.getFrom()){

            @Override
            protected void addServices(List<Service> list) throws Exception {
                list.add(service);
            }

            public String toString() {
                return "AggregatorRoute[" + this.getEndpoint() + " -> " + processor + "]";
            }
        };
    }

    public AggregatorBuilder aggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.setAggregationStrategy(aggregationStrategy);
        return this;
    }

    public AggregatorBuilder batchSize(int batchSize) {
        this.setBatchSize(batchSize);
        return this;
    }

    public AggregatorBuilder batchTimeout(int batchTimeout) {
        this.setBatchTimeout(batchTimeout);
        return this;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public long getBatchTimeout() {
        return this.batchTimeout;
    }

    public void setBatchTimeout(long batchTimeout) {
        this.batchTimeout = batchTimeout;
    }
}

