/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.Builder;
import org.apache.camel.builder.DeadLetterChannelBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.Fluent;
import org.apache.camel.builder.FluentArg;
import org.apache.camel.builder.LoggingErrorHandlerBuilder;
import org.apache.camel.builder.NoErrorHandlerBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.processor.LoggingLevel;
import org.apache.camel.processor.SendProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BuilderSupport {
    private CamelContext context;
    private ErrorHandlerBuilder errorHandlerBuilder;
    private boolean inheritErrorHandler = true;

    protected BuilderSupport(CamelContext context) {
        this.context = context;
    }

    protected BuilderSupport(BuilderSupport parent) {
        this.context = parent.getContext();
        this.inheritErrorHandler = parent.inheritErrorHandler;
        if (this.inheritErrorHandler && parent.errorHandlerBuilder != null) {
            this.errorHandlerBuilder = parent.errorHandlerBuilder.copy();
        }
    }

    @Fluent
    public ValueBuilder header(@FluentArg(value="name") String name) {
        return Builder.header(name);
    }

    @Fluent
    public ValueBuilder body() {
        return Builder.body();
    }

    @Fluent
    public <T> ValueBuilder bodyAs(@FluentArg(value="class") Class<T> type) {
        return Builder.bodyAs(type);
    }

    @Fluent
    public ValueBuilder outBody() {
        return Builder.outBody();
    }

    @Fluent
    public <T> ValueBuilder outBody(@FluentArg(value="class") Class<T> type) {
        return Builder.outBody(type);
    }

    @Fluent
    public ValueBuilder systemProperty(@FluentArg(value="name") String name) {
        return Builder.systemProperty(name);
    }

    @Fluent
    public ValueBuilder systemProperty(@FluentArg(value="name") String name, @FluentArg(value="defaultValue") String defaultValue) {
        return Builder.systemProperty(name, defaultValue);
    }

    @Fluent
    public Endpoint endpoint(@FluentArg(value="uri") String uri) {
        return this.getContext().getEndpoint(uri);
    }

    @Fluent
    public List<Endpoint> endpoints(String ... uris) {
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        for (String uri : uris) {
            endpoints.add(this.endpoint(uri));
        }
        return endpoints;
    }

    @Fluent
    public List<Endpoint> endpoints(Endpoint ... endpoints) {
        ArrayList<Endpoint> answer = new ArrayList<Endpoint>();
        for (Endpoint endpoint : endpoints) {
            answer.add(endpoint);
        }
        return answer;
    }

    @Fluent
    public NoErrorHandlerBuilder noErrorHandler() {
        return new NoErrorHandlerBuilder();
    }

    @Fluent
    public LoggingErrorHandlerBuilder loggingErrorHandler() {
        return new LoggingErrorHandlerBuilder();
    }

    @Fluent
    public LoggingErrorHandlerBuilder loggingErrorHandler(@FluentArg(value="log") String log) {
        return this.loggingErrorHandler(LogFactory.getLog((String)log));
    }

    @Fluent
    public LoggingErrorHandlerBuilder loggingErrorHandler(@FluentArg(value="log") Log log) {
        return new LoggingErrorHandlerBuilder(log);
    }

    @Fluent
    public LoggingErrorHandlerBuilder loggingErrorHandler(@FluentArg(value="log") Log log, @FluentArg(value="level") LoggingLevel level) {
        return new LoggingErrorHandlerBuilder(log, level);
    }

    @Fluent
    public DeadLetterChannelBuilder deadLetterChannel() {
        return new DeadLetterChannelBuilder();
    }

    @Fluent
    public DeadLetterChannelBuilder deadLetterChannel(@FluentArg(value="uri") String deadLetterUri) {
        return this.deadLetterChannel(this.endpoint(deadLetterUri));
    }

    @Fluent
    public DeadLetterChannelBuilder deadLetterChannel(@FluentArg(value="ref") Endpoint deadLetterEndpoint) {
        return new DeadLetterChannelBuilder(new SendProcessor(deadLetterEndpoint));
    }

    public CamelContext getContext() {
        return this.context;
    }

    public void setContext(CamelContext context) {
        this.context = context;
    }

    public ErrorHandlerBuilder getErrorHandlerBuilder() {
        if (this.errorHandlerBuilder == null) {
            this.errorHandlerBuilder = this.createErrorHandlerBuilder();
        }
        return this.errorHandlerBuilder;
    }

    protected ErrorHandlerBuilder createErrorHandlerBuilder() {
        if (this.isInheritErrorHandler()) {
            return new DeadLetterChannelBuilder();
        }
        return new NoErrorHandlerBuilder();
    }

    public void setErrorHandlerBuilder(ErrorHandlerBuilder errorHandlerBuilder) {
        this.errorHandlerBuilder = errorHandlerBuilder;
    }

    public boolean isInheritErrorHandler() {
        return this.inheritErrorHandler;
    }

    public void setInheritErrorHandler(boolean inheritErrorHandler) {
        this.inheritErrorHandler = inheritErrorHandler;
    }
}

