/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionBuilder {
    public static <E extends Exchange> Expression<E> headerExpression(final String headerName) {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                Object header = exchange.getIn().getHeader(headerName);
                if (header == null) {
                    header = exchange.getProperty(headerName);
                }
                return header;
            }

            public String toString() {
                return "header(" + headerName + ")";
            }
        };
    }

    public static <E extends Exchange> Expression<E> propertyExpression(final String propertyName) {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                return exchange.getProperty(propertyName);
            }

            public String toString() {
                return "property(" + propertyName + ")";
            }
        };
    }

    public static <E extends Exchange> Expression<E> constantExpression(final Object value) {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                return value;
            }

            public String toString() {
                return "" + value;
            }
        };
    }

    public static <E extends Exchange> Expression<E> bodyExpression() {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                return exchange.getIn().getBody();
            }

            public String toString() {
                return "body";
            }
        };
    }

    public static <E extends Exchange, T> Expression<E> bodyExpression(final Class<T> type) {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                return exchange.getIn().getBody(type);
            }

            public String toString() {
                return "bodyAs[" + type.getName() + "]";
            }
        };
    }

    public static <E extends Exchange> Expression<E> outBodyExpression() {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                return exchange.getOut().getBody();
            }

            public String toString() {
                return "outBody";
            }
        };
    }

    public static <E extends Exchange> Expression<E> exchangeExpression() {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                return exchange;
            }

            public String toString() {
                return "exchange";
            }
        };
    }

    public static <E extends Exchange> Expression<E> inMessageExpression() {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                return exchange.getIn();
            }

            public String toString() {
                return "inMessage";
            }
        };
    }

    public static <E extends Exchange> Expression<E> convertTo(final Expression expression, final Class type) {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                Object value = expression.evaluate(exchange);
                return exchange.getContext().getTypeConverter().convertTo(type, value);
            }

            public String toString() {
                return "" + expression + ".convertTo(" + type.getName() + ".class)";
            }
        };
    }

    public static <E extends Exchange> Expression<E> tokenizeExpression(final Expression<E> expression, final String token) {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                String text = ExpressionBuilder.evaluateStringExpression(expression, exchange);
                if (text == null) {
                    return null;
                }
                StringTokenizer iter = new StringTokenizer(text, token);
                ArrayList<String> answer = new ArrayList<String>();
                while (iter.hasMoreTokens()) {
                    answer.add(iter.nextToken());
                }
                return answer;
            }

            public String toString() {
                return "tokenize(" + expression + ", " + token + ")";
            }
        };
    }

    public static <E extends Exchange> Expression<E> regexTokenize(final Expression<E> expression, String regexTokenizer) {
        final Pattern pattern = Pattern.compile(regexTokenizer);
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                String text = ExpressionBuilder.evaluateStringExpression(expression, exchange);
                if (text == null) {
                    return null;
                }
                return Arrays.asList(pattern.split(text));
            }

            public String toString() {
                return "regexTokenize(" + expression + ", " + pattern.pattern() + ")";
            }
        };
    }

    public static <E extends Exchange> Expression<E> regexReplaceAll(final Expression<E> expression, String regex, final String replacement) {
        final Pattern pattern = Pattern.compile(regex);
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                String text = ExpressionBuilder.evaluateStringExpression(expression, exchange);
                if (text == null) {
                    return null;
                }
                return pattern.matcher(text).replaceAll(replacement);
            }

            public String toString() {
                return "regexReplaceAll(" + expression + ", " + pattern.pattern() + ")";
            }
        };
    }

    public static <E extends Exchange> Expression<E> regexReplaceAll(final Expression<E> expression, String regex, final Expression<E> replacementExpression) {
        final Pattern pattern = Pattern.compile(regex);
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                String text = ExpressionBuilder.evaluateStringExpression(expression, exchange);
                String replacement = ExpressionBuilder.evaluateStringExpression(replacementExpression, exchange);
                if (text == null || replacement == null) {
                    return null;
                }
                return pattern.matcher(text).replaceAll(replacement);
            }

            public String toString() {
                return "regexReplaceAll(" + expression + ", " + pattern.pattern() + ")";
            }
        };
    }

    public static <E extends Exchange> Expression<E> append(final Expression<E> left, final Expression<E> right) {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                return ExpressionBuilder.evaluateStringExpression(left, exchange) + ExpressionBuilder.evaluateStringExpression(right, exchange);
            }

            public String toString() {
                return "append(" + left + ", " + right + ")";
            }
        };
    }

    public static <E extends Exchange> String evaluateStringExpression(Expression<E> expression, E exchange) {
        Object value = expression.evaluate(exchange);
        return exchange.getContext().getTypeConverter().convertTo(String.class, value);
    }

    public static <E extends Exchange> Expression<E> systemProperty(String name) {
        return ExpressionBuilder.systemProperty(name, null);
    }

    public static <E extends Exchange> Expression<E> systemProperty(final String name, final String defaultValue) {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                return System.getProperty(name, defaultValue);
            }
        };
    }
}

