/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.FromBuilder;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.processor.FilterProcessor;

public class FilterBuilder
extends FromBuilder {
    private Predicate predicate;

    public FilterBuilder(FromBuilder builder, Predicate predicate) {
        super(builder);
        this.predicate = predicate;
    }

    public FilterBuilder and(Predicate predicate) {
        this.predicate = PredicateBuilder.and(this.predicate, predicate);
        return this;
    }

    public FilterBuilder or(Predicate predicate) {
        this.predicate = PredicateBuilder.or(this.predicate, predicate);
        return this;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public FilterProcessor createProcessor() throws Exception {
        Processor childProcessor = super.createProcessor();
        return new FilterProcessor(this.predicate, childProcessor);
    }
}

