/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.builder.AggregatorBuilder;
import org.apache.camel.builder.Builder;
import org.apache.camel.builder.BuilderSupport;
import org.apache.camel.builder.ChoiceBuilder;
import org.apache.camel.builder.ConstantProcessorBuilder;
import org.apache.camel.builder.DelayerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.FilterBuilder;
import org.apache.camel.builder.Fluent;
import org.apache.camel.builder.FluentArg;
import org.apache.camel.builder.IdempotentConsumerBuilder;
import org.apache.camel.builder.InterceptorBuilder;
import org.apache.camel.builder.MulticastBuilder;
import org.apache.camel.builder.PipelineBuilder;
import org.apache.camel.builder.PolicyBuilder;
import org.apache.camel.builder.ProcessorBuilder;
import org.apache.camel.builder.ProcessorFactory;
import org.apache.camel.builder.RecipientListBuilder;
import org.apache.camel.builder.ResequencerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.SplitterBuilder;
import org.apache.camel.builder.ThrottlerBuilder;
import org.apache.camel.builder.ToBuilder;
import org.apache.camel.impl.EventDrivenConsumerRoute;
import org.apache.camel.processor.CompositeProcessor;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.idempotent.MessageIdRepository;
import org.apache.camel.spi.Policy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FromBuilder
extends BuilderSupport
implements ProcessorFactory {
    public static final String DEFAULT_TRACE_CATEGORY = "org.apache.camel.TRACE";
    private RouteBuilder builder;
    private Endpoint from;
    private List<Processor> processors = new ArrayList<Processor>();
    private List<ProcessorFactory> processFactories = new ArrayList<ProcessorFactory>();
    private FromBuilder routeBuilder;

    public FromBuilder(RouteBuilder builder, Endpoint from) {
        super(builder);
        this.builder = builder;
        this.from = from;
    }

    public FromBuilder(FromBuilder parent) {
        super(parent);
        this.builder = parent.getBuilder();
        this.from = parent.getFrom();
    }

    @Fluent
    public ProcessorFactory to(@FluentArg(value="uri") String uri) {
        return this.to(this.endpoint(uri));
    }

    @Fluent
    public ProcessorFactory to(@FluentArg(value="ref") Endpoint endpoint) {
        ToBuilder answer = new ToBuilder(this, endpoint);
        this.addProcessBuilder(answer);
        return answer;
    }

    @Fluent
    public ProcessorFactory to(String ... uris) {
        return this.to(this.endpoints(uris));
    }

    @Fluent
    public ProcessorFactory to(Endpoint ... endpoints) {
        return this.to(this.endpoints(endpoints));
    }

    @Fluent
    public ProcessorFactory to(@FluentArg(value="endpoint", attribute=false, element=true) Collection<Endpoint> endpoints) {
        return this.addProcessBuilder(new MulticastBuilder(this, endpoints));
    }

    @Fluent
    public ProcessorFactory pipeline(String ... uris) {
        return this.pipeline(this.endpoints(uris));
    }

    @Fluent
    public ProcessorFactory pipeline(Endpoint ... endpoints) {
        return this.pipeline(this.endpoints(endpoints));
    }

    @Fluent
    public ProcessorFactory pipeline(@FluentArg(value="endpoints") Collection<Endpoint> endpoints) {
        return this.addProcessBuilder(new PipelineBuilder(this, endpoints));
    }

    @Fluent
    public IdempotentConsumerBuilder idempotentConsumer(@FluentArg(value="messageIdExpression") Expression messageIdExpression, @FluentArg(value="MessageIdRepository") MessageIdRepository messageIdRepository) {
        return (IdempotentConsumerBuilder)this.addProcessBuilder(new IdempotentConsumerBuilder(this, messageIdExpression, messageIdRepository));
    }

    @Fluent
    public FilterBuilder filter(@FluentArg(value="predicate", element=true) Predicate predicate) {
        FilterBuilder answer = new FilterBuilder(this, predicate);
        this.addProcessBuilder(answer);
        return answer;
    }

    @Fluent(nestedActions=true)
    public ChoiceBuilder choice() {
        ChoiceBuilder answer = new ChoiceBuilder(this);
        this.addProcessBuilder(answer);
        return answer;
    }

    @Fluent
    public RecipientListBuilder recipientList(@FluentArg(value="recipients", element=true) Expression receipients) {
        RecipientListBuilder answer = new RecipientListBuilder(this, receipients);
        this.addProcessBuilder(answer);
        return answer;
    }

    @Fluent
    public SplitterBuilder splitter(@FluentArg(value="recipients", element=true) Expression receipients) {
        SplitterBuilder answer = new SplitterBuilder(this, receipients);
        this.addProcessBuilder(answer);
        return answer;
    }

    public ResequencerBuilder resequencer(Expression<Exchange> expression) {
        return this.resequencer(Collections.singletonList(expression));
    }

    @Fluent
    public ResequencerBuilder resequencer(@FluentArg(value="expressions") List<Expression<Exchange>> expressions) {
        ResequencerBuilder answer = new ResequencerBuilder(this, expressions);
        this.setRouteBuilder(answer);
        return answer;
    }

    @Fluent
    public ResequencerBuilder resequencer(Expression<Exchange> ... expressions) {
        ArrayList<Expression<Exchange>> list = new ArrayList<Expression<Exchange>>();
        for (Expression<Exchange> expression : expressions) {
            list.add(expression);
        }
        return this.resequencer(list);
    }

    @Fluent
    public AggregatorBuilder aggregator(Expression correlationExpression) {
        AggregatorBuilder answer = new AggregatorBuilder(this, correlationExpression);
        this.setRouteBuilder(answer);
        return answer;
    }

    @Fluent
    public AggregatorBuilder aggregator(Expression correlationExpression, AggregationStrategy strategy) {
        AggregatorBuilder answer = new AggregatorBuilder(this, correlationExpression);
        answer.aggregationStrategy(strategy);
        this.setRouteBuilder(answer);
        return answer;
    }

    @Fluent
    public DelayerBuilder delayer(Expression<Exchange> processAtExpression) {
        return this.delayer(processAtExpression, 0L);
    }

    @Fluent
    public DelayerBuilder delayer(Expression<Exchange> processAtExpression, long delay) {
        DelayerBuilder answer = new DelayerBuilder(this, processAtExpression, delay);
        this.setRouteBuilder(answer);
        return answer;
    }

    @Fluent
    public DelayerBuilder delayer(long delay) {
        return this.delayer(null, delay);
    }

    @Fluent
    public ThrottlerBuilder throttler(long maximumRequestCount) {
        ThrottlerBuilder answer = new ThrottlerBuilder(this, maximumRequestCount);
        this.setRouteBuilder(answer);
        return answer;
    }

    @Fluent
    public FromBuilder errorHandler(@FluentArg(value="handler") ErrorHandlerBuilder errorHandlerBuilder) {
        this.setErrorHandlerBuilder(errorHandlerBuilder);
        return this;
    }

    @Fluent
    public FromBuilder inheritErrorHandler(@FluentArg(value="condition") boolean condition) {
        this.setInheritErrorHandler(condition);
        return this;
    }

    @Fluent(nestedActions=true)
    public InterceptorBuilder intercept() {
        InterceptorBuilder answer = new InterceptorBuilder(this);
        this.addProcessBuilder(answer);
        return answer;
    }

    @Fluent
    public FromBuilder trace() {
        return this.trace(DEFAULT_TRACE_CATEGORY);
    }

    @Fluent
    public FromBuilder trace(@FluentArg(value="category") String category) {
        final Log log = LogFactory.getLog((String)category);
        return this.intercept(new DelegateProcessor(){

            public void process(Exchange exchange) throws Exception {
                log.trace((Object)exchange);
                this.processNext(exchange);
            }
        });
    }

    @Fluent
    public FromBuilder intercept(@FluentArg(value="interceptor") DelegateProcessor interceptor) {
        InterceptorBuilder answer = new InterceptorBuilder(this);
        answer.add(interceptor);
        this.addProcessBuilder(answer);
        return answer.target();
    }

    @Fluent(nestedActions=true)
    public PolicyBuilder policies() {
        PolicyBuilder answer = new PolicyBuilder(this);
        this.addProcessBuilder(answer);
        return answer;
    }

    @Fluent
    public FromBuilder policy(@FluentArg(value="policy") Policy policy) {
        PolicyBuilder answer = new PolicyBuilder(this);
        answer.add(policy);
        this.addProcessBuilder(answer);
        return answer.target();
    }

    @Fluent
    public FromBuilder process(@FluentArg(value="ref") Processor processor) {
        this.addProcessorBuilder(processor);
        return this;
    }

    @Fluent
    public FromBuilder setBody(Expression expression) {
        this.addProcessorBuilder(ProcessorBuilder.setBody(expression));
        return this;
    }

    @Fluent
    public FromBuilder setOutBody(Expression expression) {
        this.addProcessorBuilder(ProcessorBuilder.setOutBody(expression));
        return this;
    }

    @Fluent
    public FromBuilder setHeader(String name, Expression expression) {
        this.addProcessorBuilder(ProcessorBuilder.setHeader(name, expression));
        return this;
    }

    @Fluent
    public FromBuilder setOutHeader(String name, Expression expression) {
        this.addProcessorBuilder(ProcessorBuilder.setOutHeader(name, expression));
        return this;
    }

    @Fluent
    public FromBuilder setProperty(String name, Expression expression) {
        this.addProcessorBuilder(ProcessorBuilder.setProperty(name, expression));
        return this;
    }

    @Fluent
    public FromBuilder convertBodyTo(Class type) {
        this.addProcessorBuilder(ProcessorBuilder.setBody(Builder.body().convertTo(type)));
        return this;
    }

    @Fluent
    public FromBuilder convertOutBodyTo(Class type) {
        this.addProcessorBuilder(ProcessorBuilder.setOutBody(Builder.outBody().convertTo(type)));
        return this;
    }

    public RouteBuilder getBuilder() {
        return this.builder;
    }

    public Endpoint getFrom() {
        return this.from;
    }

    public List<Processor> getProcessors() {
        return this.processors;
    }

    public ProcessorFactory addProcessBuilder(ProcessorFactory processFactory) {
        this.processFactories.add(processFactory);
        return processFactory;
    }

    protected void addProcessorBuilder(Processor processor) {
        this.addProcessBuilder(new ConstantProcessorBuilder(processor));
    }

    public void addProcessor(Processor processor) {
        this.processors.add(processor);
    }

    public Route createRoute() throws Exception {
        if (this.routeBuilder != null) {
            return this.routeBuilder.createRoute();
        }
        Processor processor = this.createProcessor();
        if (processor == null) {
            throw new IllegalArgumentException("No processor created for: " + this);
        }
        return new EventDrivenConsumerRoute(this.getFrom(), processor);
    }

    @Override
    public Processor createProcessor() throws Exception {
        ArrayList<Processor> answer = new ArrayList<Processor>();
        for (ProcessorFactory processFactory : this.processFactories) {
            Processor processor = this.makeProcessor(processFactory);
            if (processor == null) {
                throw new IllegalArgumentException("No processor created for processBuilder: " + processFactory);
            }
            answer.add(processor);
        }
        if (answer.size() == 0) {
            return null;
        }
        Processor processor = null;
        processor = answer.size() == 1 ? (Processor)answer.get(0) : new CompositeProcessor(answer);
        return processor;
    }

    protected Processor makeProcessor(ProcessorFactory processFactory) throws Exception {
        Processor processor = processFactory.createProcessor();
        processor = this.wrapProcessor(processor);
        return this.wrapInErrorHandler(processor);
    }

    protected Processor wrapInErrorHandler(Processor processor) throws Exception {
        return this.getErrorHandlerBuilder().createErrorHandler(processor);
    }

    protected Processor wrapProcessor(Processor processor) {
        return processor;
    }

    protected FromBuilder getRouteBuilder() {
        return this.routeBuilder;
    }

    protected void setRouteBuilder(FromBuilder routeBuilder) {
        this.routeBuilder = routeBuilder;
    }
}

