/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.Fluent;
import org.apache.camel.builder.FluentArg;
import org.apache.camel.builder.FromBuilder;
import org.apache.camel.builder.ProcessorFactory;
import org.apache.camel.spi.Policy;

public class PolicyBuilder
implements ProcessorFactory {
    private final ArrayList<Policy> policies = new ArrayList();
    private final FromBuilder parent;
    private FromBuilder target;

    public PolicyBuilder(FromBuilder parent) {
        this.parent = parent;
    }

    @Fluent(value="policy")
    public PolicyBuilder add(@FluentArg(value="ref") Policy interceptor) {
        this.policies.add(interceptor);
        return this;
    }

    @Fluent(callOnElementEnd=true)
    public FromBuilder target() {
        this.target = new FromBuilder(this.parent);
        return this.target;
    }

    public Processor createProcessor() throws Exception {
        if (this.target == null) {
            throw new RuntimeCamelException("target not provided.");
        }
        Processor last = this.target.createProcessor();
        Collections.reverse(this.policies);
        for (Policy p : this.policies) {
            last = p.wrap(last);
        }
        return last;
    }
}

