/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;

public class ProcessorBuilder {
    public static Processor setBody(final Expression expression) {
        return new Processor(){

            public void process(Exchange exchange) {
                Object newBody = expression.evaluate(exchange);
                exchange.getIn().setBody(newBody);
            }

            public String toString() {
                return "setBody(" + expression + ")";
            }
        };
    }

    public static Processor setOutBody(final Expression expression) {
        return new Processor(){

            public void process(Exchange exchange) {
                Object newBody = expression.evaluate(exchange);
                exchange.getOut().setBody(newBody);
            }

            public String toString() {
                return "setOutBody(" + expression + ")";
            }
        };
    }

    public static Processor setHeader(final String name, final Expression expression) {
        return new Processor(){

            public void process(Exchange exchange) {
                Object value = expression.evaluate(exchange);
                exchange.getIn().setHeader(name, value);
            }

            public String toString() {
                return "setHeader(" + name + ", " + expression + ")";
            }
        };
    }

    public static Processor setOutHeader(final String name, final Expression expression) {
        return new Processor(){

            public void process(Exchange exchange) {
                Object value = expression.evaluate(exchange);
                exchange.getOut().setHeader(name, value);
            }

            public String toString() {
                return "setOutHeader(" + name + ", " + expression + ")";
            }
        };
    }

    public static Processor setProperty(final String name, final Expression expression) {
        return new Processor(){

            public void process(Exchange exchange) {
                Object value = expression.evaluate(exchange);
                exchange.setProperty(name, value);
            }

            public String toString() {
                return "setProperty(" + name + ", " + expression + ")";
            }
        };
    }
}

