/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.Processor;
import org.apache.camel.builder.FromBuilder;
import org.apache.camel.processor.Throttler;

public class ThrottlerBuilder
extends FromBuilder {
    private long maximumRequestsPerPeriod;
    private long timePeriodMillis = 1000L;

    public ThrottlerBuilder(FromBuilder parent, long maximumRequestsPerPeriod) {
        super(parent);
        this.maximumRequestsPerPeriod = maximumRequestsPerPeriod;
    }

    public ThrottlerBuilder timePeriodMillis(long timePeriodMillis) {
        this.timePeriodMillis = timePeriodMillis;
        return this;
    }

    public Processor createProcessor() throws Exception {
        Processor processor = super.createProcessor();
        return new Throttler(processor, this.maximumRequestsPerPeriod, this.timePeriodMillis);
    }
}

