/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.Fluent;
import org.apache.camel.builder.FluentArg;
import org.apache.camel.builder.PredicateBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueBuilder<E extends Exchange>
implements Expression<E> {
    private Expression<E> expression;

    public ValueBuilder(Expression<E> expression) {
        this.expression = expression;
    }

    @Override
    public Object evaluate(E exchange) {
        return this.expression.evaluate(exchange);
    }

    public Expression<E> getExpression() {
        return this.expression;
    }

    public String toString() {
        return this.expression.toString();
    }

    @Fluent
    public Predicate<E> isNotEqualTo(@FluentArg(value="value") Object value) {
        Expression<E> right = this.asExpression(value);
        return this.onNewPredicate(PredicateBuilder.isNotEqualTo(this.expression, right));
    }

    @Fluent
    public Predicate<E> isEqualTo(@FluentArg(value="value") Object value) {
        Expression<E> right = this.asExpression(value);
        return this.onNewPredicate(PredicateBuilder.isEqualTo(this.expression, right));
    }

    @Fluent
    public Predicate<E> isLessThan(@FluentArg(value="value") Object value) {
        Expression<E> right = this.asExpression(value);
        return this.onNewPredicate(PredicateBuilder.isLessThan(this.expression, right));
    }

    @Fluent
    public Predicate<E> isLessThanOrEqualTo(@FluentArg(value="value") Object value) {
        Expression<E> right = this.asExpression(value);
        return this.onNewPredicate(PredicateBuilder.isLessThanOrEqualTo(this.expression, right));
    }

    @Fluent
    public Predicate<E> isGreaterThan(@FluentArg(value="value") Object value) {
        Expression<E> right = this.asExpression(value);
        return this.onNewPredicate(PredicateBuilder.isGreaterThan(this.expression, right));
    }

    @Fluent
    public Predicate<E> isGreaterThanOrEqualTo(@FluentArg(value="value") Object value) {
        Expression<E> right = this.asExpression(value);
        return this.onNewPredicate(PredicateBuilder.isGreaterThanOrEqualTo(this.expression, right));
    }

    @Fluent
    public Predicate<E> isInstanceOf(@FluentArg(value="class") Class type) {
        return this.onNewPredicate(PredicateBuilder.isInstanceOf(this.expression, type));
    }

    @Fluent
    public Predicate<E> matchesRegex(@FluentArg(value="regex") String regex) {
        return this.onNewPredicate(PredicateBuilder.regex(this.expression, regex));
    }

    @Fluent
    public Predicate<E> isNull() {
        return this.onNewPredicate(PredicateBuilder.isNull(this.expression));
    }

    @Fluent
    public Predicate<E> isNotNull() {
        return this.onNewPredicate(PredicateBuilder.isNotNull(this.expression));
    }

    @Fluent
    public Predicate<E> contains(@FluentArg(value="value") Object value) {
        Expression<E> right = this.asExpression(value);
        return this.onNewPredicate(PredicateBuilder.contains(this.expression, right));
    }

    @Fluent
    public Predicate<E> regex(String regex) {
        return this.onNewPredicate(PredicateBuilder.regex(this.expression, regex));
    }

    @Fluent
    public ValueBuilder<E> tokenize() {
        return this.tokenize("\n");
    }

    @Fluent
    public ValueBuilder<E> tokenize(@FluentArg(value="token") String token) {
        Expression<E> newExp = ExpressionBuilder.tokenizeExpression(this.expression, token);
        return new ValueBuilder<E>(newExp);
    }

    @Fluent
    public ValueBuilder<E> regexTokenize(@FluentArg(value="regex") String regex) {
        Expression<E> newExp = ExpressionBuilder.regexTokenize(this.expression, regex);
        return new ValueBuilder<E>(newExp);
    }

    @Fluent
    public ValueBuilder<E> regexReplaceAll(@FluentArg(value="regex") String regex, @FluentArg(value="replacement") String replacement) {
        Expression<E> newExp = ExpressionBuilder.regexReplaceAll(this.expression, regex, replacement);
        return new ValueBuilder<E>(newExp);
    }

    @Fluent
    public ValueBuilder<E> regexReplaceAll(@FluentArg(value="regex") String regex, @FluentArg(value="replacement") Expression<E> replacement) {
        Expression<E> newExp = ExpressionBuilder.regexReplaceAll(this.expression, regex, replacement);
        return new ValueBuilder<E>(newExp);
    }

    @Fluent
    public ValueBuilder<E> convertTo(@FluentArg(value="type") Class type) {
        Expression newExp = ExpressionBuilder.convertTo(this.expression, type);
        return new ValueBuilder(newExp);
    }

    @Fluent
    public ValueBuilder<E> convertToString() {
        return this.convertTo(String.class);
    }

    @Fluent
    public ValueBuilder<E> append(@FluentArg(value="value") Object value) {
        return new ValueBuilder<E>(ExpressionBuilder.append(this.expression, this.asExpression(value)));
    }

    protected Predicate<E> onNewPredicate(Predicate<E> predicate) {
        return predicate;
    }

    protected Expression<E> asExpression(Object value) {
        if (value instanceof Expression) {
            return (Expression)value;
        }
        return ExpressionBuilder.constantExpression(value);
    }
}

