/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathVariableResolver;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageVariableResolver
implements XPathVariableResolver {
    public static final String SYSTEM_PROPERTIES_NAMESPACE = "http://camel.apache.org/xml/variables/system-properties";
    public static final String ENVIRONMENT_VARIABLES = "http://camel.apache.org/xml/variables/environment-variables";
    public static final String EXCHANGE_PROPERTY = "http://camel.apache.org/xml/variables/exchange-property";
    public static final String IN_HEADER = "http://camel.apache.org/xml/variables/in-header";
    public static final String OUT_HEADER = "http://camel.apache.org/xml/variables/out-header";
    private static final transient Log log = LogFactory.getLog(MessageVariableResolver.class);
    private Exchange exchange;
    private Map<String, Object> variables = new HashMap<String, Object>();

    public Exchange getExchange() {
        return this.exchange;
    }

    public void setExchange(Exchange exchange) {
        this.exchange = exchange;
    }

    public Object resolveVariable(QName name) {
        String uri = name.getNamespaceURI();
        String localPart = name.getLocalPart();
        Object answer = null;
        if (uri == null || uri.length() == 0) {
            answer = this.variables.get(localPart);
            if (answer == null) {
                Message message = this.exchange.getIn();
                if (message != null) {
                    answer = message.getHeader(localPart);
                }
                if (answer == null) {
                    answer = this.exchange.getProperty(localPart);
                }
            }
        } else if (uri.equals(SYSTEM_PROPERTIES_NAMESPACE)) {
            try {
                answer = System.getProperty(localPart);
            }
            catch (Exception e) {
                log.debug((Object)("Security exception evaluating system property: " + localPart + ". Reason: " + e), (Throwable)e);
            }
        } else if (uri.equals(ENVIRONMENT_VARIABLES)) {
            answer = System.getenv().get(localPart);
        } else if (uri.equals(EXCHANGE_PROPERTY)) {
            answer = this.exchange.getProperty(localPart);
        } else if (uri.equals(IN_HEADER)) {
            answer = this.exchange.getIn().getHeader(localPart);
        } else if (uri.equals(OUT_HEADER)) {
            answer = this.exchange.getOut().getHeader(localPart);
        }
        return answer;
    }

    public void addVariable(String localPart, Object value) {
        this.variables.put(localPart, value);
    }
}

