/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.Exchange;
import org.apache.camel.ExpectedBodyTypeException;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeTransformException;
import org.apache.camel.builder.xml.DomResultHandler;
import org.apache.camel.builder.xml.ResultHandler;
import org.apache.camel.builder.xml.StreamResultHandler;
import org.apache.camel.builder.xml.StringResultHandler;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XsltBuilder
implements Processor {
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private XmlConverter converter = new XmlConverter();
    private Transformer transformer;
    private ResultHandler resultHandler = new StringResultHandler();
    private boolean failOnNullBody = true;

    public XsltBuilder() {
    }

    public XsltBuilder(Transformer transformer) {
        this.transformer = transformer;
    }

    public String toString() {
        return "XSLT[" + this.transformer + "]";
    }

    @Override
    public synchronized void process(Exchange exchange) throws Exception {
        Transformer transformer = this.getTransformer();
        if (transformer == null) {
            throw new IllegalArgumentException("No transformer configured!");
        }
        this.configureTransformer(transformer, exchange);
        Source source = this.getSource(exchange);
        Result result = this.resultHandler.getResult();
        transformer.transform(source, result);
        this.resultHandler.setBody(exchange.getIn());
    }

    public static XsltBuilder xslt(Transformer transformer) {
        return new XsltBuilder(transformer);
    }

    public static XsltBuilder xslt(Source xslt) throws TransformerConfigurationException {
        ObjectHelper.notNull(xslt, "xslt");
        XsltBuilder answer = new XsltBuilder();
        answer.setTransformerSource(xslt);
        return answer;
    }

    public static XsltBuilder xslt(File xslt) throws TransformerConfigurationException {
        ObjectHelper.notNull(xslt, "xslt");
        return XsltBuilder.xslt(new StreamSource(xslt));
    }

    public static XsltBuilder xslt(URL xslt) throws TransformerConfigurationException, IOException {
        ObjectHelper.notNull(xslt, "xslt");
        return XsltBuilder.xslt(xslt.openStream());
    }

    public static XsltBuilder xslt(InputStream xslt) throws TransformerConfigurationException, IOException {
        ObjectHelper.notNull(xslt, "xslt");
        return XsltBuilder.xslt(new StreamSource(xslt));
    }

    public XsltBuilder outputBytes() {
        this.setResultHandler(new StreamResultHandler());
        return this;
    }

    public XsltBuilder outputString() {
        this.setResultHandler(new StringResultHandler());
        return this;
    }

    public XsltBuilder outputDOM() {
        this.setResultHandler(new DomResultHandler());
        return this;
    }

    public XsltBuilder parameter(String name, Object value) {
        this.parameters.put(name, value);
        return this;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    public boolean isFailOnNullBody() {
        return this.failOnNullBody;
    }

    public void setFailOnNullBody(boolean failOnNullBody) {
        this.failOnNullBody = failOnNullBody;
    }

    public ResultHandler getResultHandler() {
        return this.resultHandler;
    }

    public void setResultHandler(ResultHandler resultHandler) {
        this.resultHandler = resultHandler;
    }

    public void setTransformerSource(Source source) throws TransformerConfigurationException {
        this.setTransformer(this.converter.getTransformerFactory().newTransformer(source));
    }

    protected Source getSource(Exchange exchange) {
        Message in = exchange.getIn();
        Source source = in.getBody(Source.class);
        if (source == null) {
            if (this.isFailOnNullBody()) {
                throw new ExpectedBodyTypeException(exchange, Source.class);
            }
            try {
                source = this.converter.toSource(this.converter.createDocument());
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeTransformException(e);
            }
        }
        return source;
    }

    protected void configureTransformer(Transformer transformer, Exchange exchange) {
        transformer.clearParameters();
        this.addParameters(transformer, exchange.getProperties());
        this.addParameters(transformer, exchange.getIn().getHeaders());
        this.addParameters(transformer, this.getParameters());
        transformer.setParameter("exchange", exchange);
        transformer.setParameter("in", exchange.getIn());
        transformer.setParameter("out", exchange.getOut());
    }

    protected void addParameters(Transformer transformer, Map<String, Object> map) {
        Set<Map.Entry<String, Object>> propertyEntries = map.entrySet();
        for (Map.Entry<String, Object> entry : propertyEntries) {
            transformer.setParameter(entry.getKey(), entry.getValue());
        }
    }
}

