/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.Processor;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.file.FileExchange;
import org.apache.camel.component.file.strategy.FileStrategy;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileConsumer
extends ScheduledPollConsumer<FileExchange> {
    private static final transient Log log = LogFactory.getLog(FileConsumer.class);
    private final FileEndpoint endpoint;
    private boolean recursive = true;
    private String regexPattern = "";
    private long lastPollTime = 0L;

    public FileConsumer(FileEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = endpoint;
    }

    @Override
    protected void poll() throws Exception {
        this.pollFileOrDirectory(this.endpoint.getFile(), this.isRecursive());
        this.lastPollTime = System.currentTimeMillis();
    }

    protected void pollFileOrDirectory(File fileOrDirectory, boolean processDir) {
        if (!fileOrDirectory.isDirectory()) {
            this.pollFile(fileOrDirectory);
        } else if (processDir) {
            if (this.isValidFile(fileOrDirectory)) {
                log.debug((Object)("Polling directory " + fileOrDirectory));
                File[] files = fileOrDirectory.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    this.pollFileOrDirectory(files[i], this.isRecursive());
                }
            }
        } else {
            log.debug((Object)("Skipping directory " + fileOrDirectory));
        }
    }

    protected void pollFile(File file) {
        if (file.exists() && file.lastModified() > this.lastPollTime && this.isValidFile(file)) {
            FileStrategy strategy = this.endpoint.getFileStrategy();
            FileExchange exchange = this.endpoint.createExchange(file);
            try {
                if (strategy.begin(this.endpoint, exchange, file)) {
                    this.getProcessor().process(exchange);
                    strategy.commit(this.endpoint, exchange, file);
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)(this.endpoint + " cannot process file: " + file));
                }
            }
            catch (Throwable e) {
                this.handleException(e);
            }
        }
    }

    protected boolean isValidFile(File file) {
        boolean result = false;
        if (file != null && file.exists() && this.isMatched(file)) {
            result = true;
        }
        return result;
    }

    protected boolean isMatched(File file) {
        String[] prefixes;
        String name = file.getName();
        if (this.regexPattern != null && this.regexPattern.length() > 0 && !name.matches(this.getRegexPattern())) {
            return false;
        }
        for (String prefix : prefixes = this.endpoint.getExcludedNamePrefixes()) {
            if (!name.startsWith(prefix)) continue;
            return false;
        }
        return true;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public String getRegexPattern() {
        return this.regexPattern;
    }

    public void setRegexPattern(String regexPattern) {
        this.regexPattern = regexPattern;
    }
}

