/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.file.FileComponent;
import org.apache.camel.component.file.FileConsumer;
import org.apache.camel.component.file.FileExchange;
import org.apache.camel.component.file.FileProducer;
import org.apache.camel.component.file.strategy.DeleteFileStrategy;
import org.apache.camel.component.file.strategy.FileStrategy;
import org.apache.camel.component.file.strategy.NoOpFileStrategy;
import org.apache.camel.component.file.strategy.RenameFileStrategy;
import org.apache.camel.impl.ScheduledPollEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileEndpoint
extends ScheduledPollEndpoint<FileExchange> {
    private File file;
    private FileStrategy fileStrategy;
    private boolean autoCreate = true;
    private boolean lock = true;
    private boolean delete = false;
    private boolean noop = false;
    private String moveNamePrefix = null;
    private String moveNamePostfix = null;
    private String[] excludedNamePrefixes = new String[]{"."};

    protected FileEndpoint(File file, String endpointUri, FileComponent component) {
        super(endpointUri, component);
        this.file = file;
    }

    @Override
    public Producer<FileExchange> createProducer() throws Exception {
        FileProducer result = new FileProducer(this);
        return result;
    }

    @Override
    public Consumer<FileExchange> createConsumer(Processor file) throws Exception {
        FileConsumer result = new FileConsumer(this, file);
        this.configureConsumer(result);
        return result;
    }

    public FileExchange createExchange(File file) {
        return new FileExchange(this.getContext(), file);
    }

    @Override
    public FileExchange createExchange() {
        return this.createExchange(this.getFile());
    }

    public File getFile() {
        if (this.autoCreate && !this.file.exists()) {
            this.file.mkdirs();
        }
        return this.file;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    public boolean isAutoCreate() {
        return this.autoCreate;
    }

    public void setAutoCreate(boolean autoCreate) {
        this.autoCreate = autoCreate;
    }

    public FileStrategy getFileStrategy() {
        if (this.fileStrategy == null) {
            this.fileStrategy = this.createFileStrategy();
        }
        return this.fileStrategy;
    }

    public void setFileStrategy(FileStrategy fileStrategy) {
        this.fileStrategy = fileStrategy;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public boolean isLock() {
        return this.lock;
    }

    public void setLock(boolean lock) {
        this.lock = lock;
    }

    public String getMoveNamePostfix() {
        return this.moveNamePostfix;
    }

    public void setMoveNamePostfix(String moveNamePostfix) {
        this.moveNamePostfix = moveNamePostfix;
    }

    public String getMoveNamePrefix() {
        return this.moveNamePrefix;
    }

    public void setMoveNamePrefix(String moveNamePrefix) {
        this.moveNamePrefix = moveNamePrefix;
    }

    public String[] getExcludedNamePrefixes() {
        return this.excludedNamePrefixes;
    }

    public void setExcludedNamePrefixes(String[] excludedNamePrefixes) {
        this.excludedNamePrefixes = excludedNamePrefixes;
    }

    public boolean isNoop() {
        return this.noop;
    }

    public void setNoop(boolean noop) {
        this.noop = noop;
    }

    protected FileStrategy createFileStrategy() {
        if (this.moveNamePostfix != null || this.moveNamePrefix != null) {
            if (this.isDelete()) {
                throw new IllegalArgumentException("You cannot set the deleteFiles property and a moveFilenamePostfix or moveFilenamePrefix");
            }
            return new RenameFileStrategy(this.isLock(), this.moveNamePrefix, this.moveNamePostfix);
        }
        if (this.isDelete()) {
            return new DeleteFileStrategy(this.isLock());
        }
        if (this.isNoop()) {
            return new NoOpFileStrategy(this.isLock());
        }
        return new RenameFileStrategy(this.isLock());
    }
}

