/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.file.FileExchange;
import org.apache.camel.impl.DefaultMessage;

public class FileMessage
extends DefaultMessage {
    private File file;

    public FileMessage() {
        this(new File("."));
    }

    public FileMessage(File file) {
        this.file = file;
    }

    public String toString() {
        return "FileMessage: " + this.file;
    }

    public FileExchange getExchange() {
        return (FileExchange)super.getExchange();
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public FileMessage newInstance() {
        return new FileMessage();
    }

    protected Object createBody() {
        if (this.file != null) {
            try {
                return new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeCamelException("File has been deleted: " + this.file + ". Reason: " + e, e);
            }
        }
        return super.createBody();
    }
}

