/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.file.FileExchange;
import org.apache.camel.impl.DefaultProducer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileProducer
extends DefaultProducer {
    private static final transient Log log = LogFactory.getLog(FileProducer.class);
    private final FileEndpoint endpoint;

    public FileProducer(FileEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) {
        this.process((FileExchange)this.endpoint.toExchangeType(exchange));
    }

    public void process(FileExchange exchange) {
        String fileName = exchange.getIn().getMessageId();
        ByteBuffer payload = exchange.getIn().getBody(ByteBuffer.class);
        payload.flip();
        File file = null;
        File endpointFile = this.endpoint.getFile();
        file = endpointFile != null && endpointFile.isDirectory() ? new File(endpointFile, fileName) : new File(fileName);
        this.buildDirectory(file);
        try {
            FileChannel fc = new RandomAccessFile(file, "rw").getChannel();
            fc.position(fc.size());
            fc.write(payload);
            fc.close();
        }
        catch (Throwable e) {
            log.error((Object)("Failed to write to File: " + file), e);
        }
    }

    private void buildDirectory(File file) {
        String dirName = file.getAbsolutePath();
        int index = dirName.lastIndexOf(File.separatorChar);
        if (index > 0) {
            dirName = dirName.substring(0, index);
            File dir = new File(dirName);
            dir.mkdirs();
        }
    }
}

