/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.file.FileExchange;
import org.apache.camel.component.file.strategy.FileStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class FileStategySupport
implements FileStrategy {
    private static final transient Log log = LogFactory.getLog(FileStategySupport.class);
    private boolean lockFile;

    protected FileStategySupport() {
        this(true);
    }

    protected FileStategySupport(boolean lockFile) {
        this.lockFile = lockFile;
    }

    public boolean begin(FileEndpoint endpoint, FileExchange exchange, File file) throws Exception {
        if (this.isLockFile()) {
            FileChannel channel;
            FileLock lock;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Locking file: " + file));
            }
            if ((lock = (channel = new RandomAccessFile(file, "rw").getChannel()).lock()) != null) {
                exchange.setProperty("org.apache.camel.fileChannel", channel);
                exchange.setProperty("org.apache.camel.file.lock", lock);
                return true;
            }
            return false;
        }
        return true;
    }

    public void commit(FileEndpoint endpoint, FileExchange exchange, File file) throws Exception {
        if (this.isLockFile()) {
            Channel channel = exchange.getProperty("org.apache.camel.fileChannel", Channel.class);
            if (channel != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Unlocking file: " + file));
                }
                channel.close();
            } else {
                throw new Exception("No Channel available to close on exchange: " + exchange);
            }
        }
    }

    public boolean isLockFile() {
        return this.lockFile;
    }

    public void setLockFile(boolean lockFile) {
        this.lockFile = lockFile;
    }
}

