/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.io.File;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.file.FileExchange;
import org.apache.camel.component.file.strategy.FileStategySupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RenameFileStrategy
extends FileStategySupport {
    private static final transient Log log = LogFactory.getLog(RenameFileStrategy.class);
    private String namePrefix;
    private String namePostfix;

    public RenameFileStrategy() {
        this(true);
    }

    public RenameFileStrategy(boolean lock) {
        this(lock, ".camel/", "");
    }

    public RenameFileStrategy(boolean lock, String namePrefix, String namePostfix) {
        super(lock);
        if (namePrefix != null) {
            this.namePrefix = namePrefix;
        }
        if (namePostfix != null) {
            this.namePostfix = namePostfix;
        }
    }

    public void commit(FileEndpoint endpoint, FileExchange exchange, File file) throws Exception {
        File parent = file.getParentFile();
        String name = this.getNamePrefix() + file.getName() + this.getNamePostfix();
        File newName = new File(parent, name);
        newName.getParentFile().mkdirs();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Renaming file: " + file + " to: " + newName));
        }
        file.renameTo(newName);
        super.commit(endpoint, exchange, file);
    }

    public String getNamePostfix() {
        return this.namePostfix;
    }

    public void setNamePostfix(String namePostfix) {
        this.namePostfix = namePostfix;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }
}

