/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.queue;

import java.util.concurrent.TimeUnit;
import org.apache.camel.AlreadyStoppedException;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.queue.QueueEndpoint;
import org.apache.camel.impl.ServiceSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueConsumer<E extends Exchange>
extends ServiceSupport
implements Consumer<E>,
Runnable {
    private static final Log log = LogFactory.getLog(QueueConsumer.class);
    private QueueEndpoint<E> endpoint;
    private Processor processor;
    private Thread thread;

    public QueueConsumer(QueueEndpoint<E> endpoint, Processor processor) {
        this.endpoint = endpoint;
        this.processor = processor;
    }

    public String toString() {
        return "QueueConsumer: " + this.endpoint.getEndpointUri();
    }

    @Override
    public void run() {
        while (!this.isStopping()) {
            Exchange exchange;
            try {
                exchange = (Exchange)this.endpoint.getQueue().poll(1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                break;
            }
            if (exchange == null || this.isStopping()) continue;
            try {
                this.processor.process(exchange);
            }
            catch (AlreadyStoppedException e) {
                log.debug((Object)("Ignoring failed message due to shutdown: " + e), (Throwable)e);
                break;
            }
            catch (Throwable e) {
                log.error((Object)e);
            }
        }
    }

    @Override
    protected void doStart() throws Exception {
        this.thread = new Thread((Runnable)this, this.getThreadName(this.endpoint.getEndpointUri()));
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    protected void doStop() throws Exception {
        this.thread.join();
    }
}

