/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.util.FactoryFinder;
import org.apache.camel.util.NoFactoryAvailableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultComponentResolver<E extends Exchange>
implements ComponentResolver<E> {
    protected static final FactoryFinder componentFactory = new FactoryFinder("META-INF/services/org/apache/camel/component/");

    @Override
    public Component<E> resolveComponent(String name, CamelContext context) {
        Class type;
        try {
            type = componentFactory.findClass(name);
        }
        catch (NoFactoryAvailableException e) {
            return null;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Invalid URI, no EndpointResolver registered for scheme : " + name, e);
        }
        if (type == null) {
            return null;
        }
        if (Component.class.isAssignableFrom(type)) {
            return (Component)context.getInjector().newInstance(type);
        }
        throw new IllegalArgumentException("Type is not a Component implementation. Found: " + type.getName());
    }
}

