/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AlreadyStoppedException;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.Delayer;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DelayProcessorSupport
extends DelegateProcessor {
    private static final transient Log log = LogFactory.getLog(Delayer.class);
    private CountDownLatch stoppedLatch = new CountDownLatch(1);
    private boolean fastStop = true;

    public DelayProcessorSupport(Processor processor) {
        super(processor);
    }

    public void process(Exchange exchange) throws Exception {
        this.delay(exchange);
        super.process(exchange);
    }

    public boolean isFastStop() {
        return this.fastStop;
    }

    public void setFastStop(boolean fastStop) {
        this.fastStop = fastStop;
    }

    protected void doStop() throws Exception {
        this.stoppedLatch.countDown();
        super.doStop();
    }

    protected abstract void delay(Exchange var1) throws Exception;

    protected void waitUntil(long time, Exchange exchange) throws Exception {
        long delay;
        while ((delay = time - this.currentSystemTime()) >= 0L) {
            if (this.isFastStop() && (this.isStopped() || this.isStopping())) {
                throw new AlreadyStoppedException();
            }
            try {
                this.sleep(delay);
                continue;
            }
            catch (InterruptedException e) {
                this.handleSleepInteruptedException(e);
                continue;
            }
            break;
        }
        return;
    }

    protected void sleep(long delay) throws InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sleeping for: " + delay + " millis"));
        }
        if (this.isFastStop()) {
            this.stoppedLatch.await(delay, TimeUnit.MILLISECONDS);
        } else {
            Thread.sleep(delay);
        }
    }

    protected void handleSleepInteruptedException(InterruptedException e) {
        log.debug((Object)("Sleep interupted: " + e), (Throwable)e);
    }

    protected long currentSystemTime() {
        return System.currentTimeMillis();
    }
}

