/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.processor.ErrorHandler;
import org.apache.camel.processor.LoggingLevel;
import org.apache.camel.util.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoggingErrorHandler
extends ServiceSupport
implements ErrorHandler {
    private Processor output;
    private Log log;
    private LoggingLevel level;

    public LoggingErrorHandler(Processor output) {
        this(output, LogFactory.getLog(LoggingErrorHandler.class), LoggingLevel.INFO);
    }

    public LoggingErrorHandler(Processor output, Log log, LoggingLevel level) {
        this.output = output;
        this.log = log;
        this.level = level;
    }

    public String toString() {
        return "LoggingErrorHandler[" + this.output + "]";
    }

    public void process(Exchange exchange) throws Exception {
        try {
            this.output.process(exchange);
        }
        catch (RuntimeException e) {
            this.logError(exchange, e);
        }
    }

    public Processor getOutput() {
        return this.output;
    }

    public LoggingLevel getLevel() {
        return this.level;
    }

    public void setLevel(LoggingLevel level) {
        this.level = level;
    }

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    protected void logError(Exchange exchange, RuntimeException e) {
        switch (this.level) {
            case DEBUG: {
                if (!this.log.isDebugEnabled()) break;
                this.log.debug(this.logMessage(exchange, e), (Throwable)e);
                break;
            }
            case ERROR: {
                if (!this.log.isErrorEnabled()) break;
                this.log.error(this.logMessage(exchange, e), (Throwable)e);
                break;
            }
            case FATAL: {
                if (!this.log.isFatalEnabled()) break;
                this.log.fatal(this.logMessage(exchange, e), (Throwable)e);
                break;
            }
            case INFO: {
                if (!this.log.isInfoEnabled()) break;
                this.log.debug(this.logMessage(exchange, e), (Throwable)e);
                break;
            }
            case TRACE: {
                if (!this.log.isTraceEnabled()) break;
                this.log.trace(this.logMessage(exchange, e), (Throwable)e);
                break;
            }
            case WARN: {
                if (!this.log.isWarnEnabled()) break;
                this.log.warn(this.logMessage(exchange, e), (Throwable)e);
                break;
            }
            default: {
                this.log.error((Object)("Unknown level: " + (Object)((Object)this.level) + " when trying to log exchange: " + this.logMessage(exchange, e)), (Throwable)e);
            }
        }
    }

    protected Object logMessage(Exchange exchange, RuntimeException e) {
        return e + " while processing exchange: " + exchange;
    }

    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.output);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.output);
    }
}

