/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.converter.ObjectConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectHelper {
    private static final transient Log log = LogFactory.getLog(ObjectHelper.class);

    public static boolean equals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        return a != null && b != null && a.equals(b);
    }

    public static int compare(Object a, Object b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a instanceof Comparable) {
            Comparable comparable = (Comparable)a;
            return comparable.compareTo(b);
        }
        int answer = a.getClass().getName().compareTo(b.getClass().getName());
        if (answer == 0) {
            answer = a.hashCode() - b.hashCode();
        }
        return answer;
    }

    public static void notNull(Object value, String name) {
        if (value == null) {
            throw new IllegalArgumentException("No " + name + " specified");
        }
    }

    public static String[] splitOnCharacter(String value, String needle, int count) {
        String[] rc = new String[count];
        rc[0] = value;
        for (int i = 1; i < count; ++i) {
            String v = rc[i - 1];
            int p = v.indexOf(needle);
            if (p < 0) {
                return rc;
            }
            rc[i - 1] = v.substring(0, p);
            rc[i] = v.substring(p + 1);
        }
        return rc;
    }

    public static String removeStartingCharacters(String text, char ch) {
        int idx = 0;
        while (text.charAt(idx) == ch) {
            ++idx;
        }
        if (idx > 0) {
            return text.substring(idx);
        }
        return text;
    }

    public static boolean contains(Object collectionOrArray, Object value) {
        if (collectionOrArray instanceof Collection) {
            Collection collection = (Collection)collectionOrArray;
            return collection.contains(value);
        }
        Iterator iter = ObjectConverter.iterator(value);
        while (iter.hasNext()) {
            if (!ObjectHelper.equals(value, iter.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(List list) {
        if (!list.isEmpty()) {
            Object value = list.get(0);
            if (value instanceof Boolean) {
                Boolean flag = (Boolean)value;
                return flag;
            }
            return true;
        }
        return false;
    }

    public static boolean isNotNullAndNonEmpty(String text) {
        return text != null && text.trim().length() > 0;
    }

    public static boolean isNullOrBlank(String text) {
        return text == null || text.trim().length() <= 0;
    }

    public static String getSystemProperty(String name, String defaultValue) {
        try {
            return System.getProperty(name, defaultValue);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Caught security exception accessing system property: " + name + ". Reason: " + e), (Throwable)e);
            }
            return defaultValue;
        }
    }

    public static String name(Class type) {
        return type != null ? type.getName() : null;
    }

    public static String className(Object value) {
        return ObjectHelper.name(value != null ? value.getClass() : null);
    }

    public static Class<?> loadClass(String name) {
        return ObjectHelper.loadClass(name, ObjectHelper.class.getClassLoader());
    }

    public static Class<?> loadClass(String name, ClassLoader loader) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            try {
                return contextClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                try {
                    return loader.loadClass(name);
                }
                catch (ClassNotFoundException e1) {
                    log.debug((Object)("Could not find class: " + name + ". Reason: " + e));
                }
            }
        }
        return null;
    }

    public static Object invokeMethod(Method method, Object instance, Object ... parameters) {
        try {
            return method.invoke(instance, parameters);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeCamelException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeCamelException(e.getCause());
        }
    }

    public static List<Method> findMethodsWithAnnotation(Class<?> type, Class<? extends Annotation> annotationType) {
        ArrayList<Method> answer = new ArrayList<Method>();
        do {
            Method[] methods;
            for (Method method : methods = type.getDeclaredMethods()) {
                if (method.getAnnotation(annotationType) == null) continue;
                answer.add(method);
            }
        } while ((type = type.getSuperclass()) != null);
        return answer;
    }

    public static String asString(Object[] objects) {
        if (objects == null) {
            return "null";
        }
        StringBuffer buffer = new StringBuffer("{");
        int counter = 0;
        for (Object object : objects) {
            if (counter++ > 0) {
                buffer.append(", ");
            }
            String text = object == null ? "null" : object.toString();
            buffer.append(text);
        }
        buffer.append("}");
        return buffer.toString();
    }
}

