/*
 * Decompiled with CFR 0.152.
 */
package org.jencks;

import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.work.WorkManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.connector.work.GeronimoWorkManager;
import org.apache.geronimo.transaction.manager.GeronimoTransactionManager;
import org.jencks.JCAConnector;
import org.jencks.factory.GeronimoDefaults;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class JCAContainer
implements InitializingBean,
DisposableBean,
ApplicationContextAware {
    private static final Log log = LogFactory.getLog((Class)JCAContainer.class);
    private BootstrapContext bootstrapContext;
    private ResourceAdapter resourceAdapter;
    private ApplicationContext applicationContext;
    private boolean lazyLoad = false;
    private GeronimoTransactionManager transactionManager;
    private WorkManager workManager;
    private boolean createdWorkManager;
    private int threadPoolSize;

    public JCAConnector addConnector() {
        return new JCAConnector(this.getBootstrapContext(), this.getResourceAdapter());
    }

    public void afterPropertiesSet() throws Exception {
        if (this.resourceAdapter == null) {
            throw new IllegalArgumentException("resourceAdapter must be set");
        }
        if (this.bootstrapContext == null) {
            if (this.transactionManager == null) {
                throw new IllegalArgumentException("bootstrapContext or transactionManager must be set");
            }
            if (this.workManager == null) {
                this.workManager = GeronimoDefaults.createWorkManager(this.transactionManager, this.threadPoolSize);
                this.createdWorkManager = true;
            }
            this.bootstrapContext = GeronimoDefaults.createBootstrapContext(this.transactionManager, this.workManager);
        }
        this.resourceAdapter.start(this.bootstrapContext);
        if (!this.lazyLoad) {
            if (this.applicationContext == null) {
                throw new IllegalArgumentException("applicationContext should have been set by Spring");
            }
            this.applicationContext.getBeansOfType(JCAConnector.class);
        }
        String version = null;
        Package aPackage = Package.getPackage("org.jencks");
        if (aPackage != null) {
            version = aPackage.getImplementationVersion();
        }
        log.info((Object)("Jencks JCA Container (http://jencks.org/) has started running version: " + version));
    }

    public void destroy() throws Exception {
        if (this.resourceAdapter != null) {
            this.resourceAdapter.stop();
        }
        if (this.createdWorkManager && this.workManager instanceof GeronimoWorkManager) {
            GeronimoWorkManager geronimoWorkManager = (GeronimoWorkManager)this.workManager;
            geronimoWorkManager.doStop();
            Object var1_1 = null;
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    public void setResourceAdapter(ResourceAdapter resourceAdapter) {
        this.resourceAdapter = resourceAdapter;
    }

    public BootstrapContext getBootstrapContext() {
        return this.bootstrapContext;
    }

    public void setBootstrapContext(BootstrapContext bootstrapContext) {
        this.bootstrapContext = bootstrapContext;
    }

    public boolean isLazyLoad() {
        return this.lazyLoad;
    }

    public void setLazyLoad(boolean lazyLoad) {
        this.lazyLoad = lazyLoad;
    }

    public GeronimoTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(GeronimoTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public WorkManager getWorkManager() {
        return this.workManager;
    }

    public void setWorkManager(WorkManager workManager) {
        this.workManager = workManager;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }
}

