/*
 * Decompiled with CFR 0.152.
 */
package org.jencks.factory;

import javax.resource.spi.XATerminator;
import javax.resource.spi.work.WorkManager;
import org.apache.geronimo.connector.GeronimoBootstrapContext;
import org.apache.geronimo.connector.work.GeronimoWorkManager;
import org.apache.geronimo.transaction.manager.GeronimoTransactionManager;
import org.jencks.factory.GeronimoDefaults;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class BootstrapContextFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    private GeronimoBootstrapContext bootstrapContext;
    private WorkManager workManager;
    private boolean createdWorkManager;
    private GeronimoTransactionManager transactionManager;
    private int threadPoolSize;

    public Object getObject() throws Exception {
        if (this.bootstrapContext == null) {
            if (this.transactionManager == null) {
                throw new FatalBeanException("transactionManager is null");
            }
            this.bootstrapContext = new GeronimoBootstrapContext(this.workManager, (XATerminator)this.transactionManager);
        }
        return this.bootstrapContext;
    }

    public Class getObjectType() {
        return GeronimoBootstrapContext.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws Exception {
        if (this.createdWorkManager && this.workManager instanceof GeronimoWorkManager) {
            GeronimoWorkManager geronimoWorkManager = (GeronimoWorkManager)this.workManager;
            geronimoWorkManager.doStop();
            Object var1_1 = null;
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.transactionManager == null) {
            throw new FatalBeanException("Geronimo transaction manager was not set");
        }
        if (this.workManager == null) {
            this.workManager = GeronimoDefaults.createWorkManager(this.transactionManager, this.getThreadPoolSize());
            this.createdWorkManager = true;
        }
    }

    public WorkManager getWorkManager() {
        return this.workManager;
    }

    public void setWorkManager(WorkManager workManager) {
        this.workManager = workManager;
    }

    public GeronimoTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(GeronimoTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }
}

