/*
 * Decompiled with CFR 0.152.
 */
package org.jencks.factory;

import javax.resource.spi.ConnectionManager;
import javax.transaction.TransactionManager;
import org.apache.geronimo.connector.outbound.GenericConnectionManager;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.NoPool;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PartitionedPool;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PoolingSupport;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.SinglePool;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.TransactionSupport;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectionTracker;
import org.jencks.factory.GeronimoDefaults;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class ConnectionManagerFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    private GenericConnectionManager connectionManager;
    private TransactionManager transactionManager;
    private TransactionSupport transactionSupport;
    private String transaction;
    private boolean containerManagedSecurity;
    private ConnectionTracker connectionTracker;
    private PoolingSupport poolingSupport;
    private boolean pooling = true;
    private String partitionStrategy;
    private int poolMaxSize = 10;
    private int poolMinSize = 0;
    private boolean allConnectionsEqual = true;
    private int connectionMaxWaitMilliseconds = 5000;
    private int connectionMaxIdleMinutes = 15;

    public Object getObject() throws Exception {
        if (this.connectionManager == null) {
            if (this.transactionManager == null) {
                throw new NullPointerException("transactionManager is null");
            }
            this.connectionManager = new GenericConnectionManager(this.transactionSupport, this.poolingSupport, this.containerManagedSecurity, this.connectionTracker, this.transactionManager, this.getClass().getName(), this.getClass().getClassLoader());
            this.connectionManager.doStart();
        }
        return this.connectionManager;
    }

    public void destroy() throws Exception {
        if (this.connectionManager != null) {
            this.connectionManager.doStop();
            this.connectionManager = null;
        }
    }

    public Class getObjectType() {
        return ConnectionManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public PoolingSupport getPoolingSupport() {
        return this.poolingSupport;
    }

    public void setPoolingSupport(PoolingSupport support) {
        this.poolingSupport = support;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager manager) {
        this.transactionManager = manager;
    }

    public String getTransaction() {
        return this.transaction;
    }

    public void setTransaction(String transaction) {
        this.transaction = transaction;
    }

    public TransactionSupport getTransactionSupport() {
        return this.transactionSupport;
    }

    public void setTransactionSupport(TransactionSupport support) {
        this.transactionSupport = support;
    }

    public ConnectionTracker getConnectionTracker() {
        return this.connectionTracker;
    }

    public void setConnectionTracker(ConnectionTracker tracker) {
        this.connectionTracker = tracker;
    }

    public boolean isContainerManagedSecurity() {
        return this.containerManagedSecurity;
    }

    public void setContainerManagedSecurity(boolean containerManagedSecurity) {
        this.containerManagedSecurity = containerManagedSecurity;
    }

    public boolean isPooling() {
        return this.pooling;
    }

    public void setPooling(boolean pooling) {
        this.pooling = pooling;
    }

    public String getPartitionStrategy() {
        return this.partitionStrategy;
    }

    public void setPartitionStrategy(String partitionStrategy) {
        this.partitionStrategy = partitionStrategy;
    }

    public int getPoolMaxSize() {
        return this.poolMaxSize;
    }

    public void setPoolMaxSize(int poolMaxSize) {
        this.poolMaxSize = poolMaxSize;
    }

    public int getPoolMinSize() {
        return this.poolMinSize;
    }

    public void setPoolMinSize(int poolMinSize) {
        this.poolMinSize = poolMinSize;
    }

    public boolean isAllConnectionsEqual() {
        return this.allConnectionsEqual;
    }

    public void setAllConnectionsEqual(boolean allConnectionsEqual) {
        this.allConnectionsEqual = allConnectionsEqual;
    }

    public int getConnectionMaxWaitMilliseconds() {
        return this.connectionMaxWaitMilliseconds;
    }

    public void setConnectionMaxWaitMilliseconds(int connectionMaxWaitMilliseconds) {
        this.connectionMaxWaitMilliseconds = connectionMaxWaitMilliseconds;
    }

    public int getConnectionMaxIdleMinutes() {
        return this.connectionMaxIdleMinutes;
    }

    public void setConnectionMaxIdleMinutes(int connectionMaxIdleMinutes) {
        this.connectionMaxIdleMinutes = connectionMaxIdleMinutes;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.transactionSupport == null) {
            this.transactionSupport = GeronimoDefaults.createTransactionSupport(this.transaction);
        }
        if (this.poolingSupport == null) {
            if (!this.pooling) {
                this.poolingSupport = new NoPool();
            } else if (this.partitionStrategy == null || "none".equalsIgnoreCase(this.partitionStrategy)) {
                this.poolingSupport = new SinglePool(this.poolMaxSize, this.poolMinSize, this.connectionMaxWaitMilliseconds, this.connectionMaxIdleMinutes, this.allConnectionsEqual, !this.allConnectionsEqual, false);
            } else if ("by-connector-properties".equalsIgnoreCase(this.partitionStrategy)) {
                this.poolingSupport = new PartitionedPool(this.poolMaxSize, this.poolMinSize, this.connectionMaxWaitMilliseconds, this.connectionMaxIdleMinutes, this.allConnectionsEqual, !this.allConnectionsEqual, false, true, false);
            } else if ("by-subject".equalsIgnoreCase(this.partitionStrategy)) {
                this.poolingSupport = new PartitionedPool(this.poolMaxSize, this.poolMinSize, this.connectionMaxWaitMilliseconds, this.connectionMaxIdleMinutes, this.allConnectionsEqual, !this.allConnectionsEqual, false, false, true);
            } else {
                throw new FatalBeanException("Unknown partition strategy " + this.partitionStrategy);
            }
        }
    }
}

