/*
 * Decompiled with CFR 0.152.
 */
package org.jencks.factory;

import java.util.Collection;
import org.apache.geronimo.transaction.log.HOWLLog;
import org.apache.geronimo.transaction.manager.TransactionLog;
import org.apache.geronimo.transaction.manager.XidFactory;
import org.apache.geronimo.transaction.manager.XidFactoryImpl;
import org.jencks.GeronimoPlatformTransactionManager;
import org.jencks.factory.GeronimoDefaults;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class TransactionManagerFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    private GeronimoPlatformTransactionManager transactionManager;
    private int defaultTransactionTimeoutSeconds = 600;
    private XidFactory xidFactory;
    private TransactionLog transactionLog;
    private String transactionLogDir;
    private Collection resourceManagers;
    private boolean createdTransactionLog;

    public Object getObject() throws Exception {
        if (this.transactionManager == null) {
            this.transactionManager = new GeronimoPlatformTransactionManager(this.defaultTransactionTimeoutSeconds, this.xidFactory, this.transactionLog, this.resourceManagers);
        }
        return this.transactionManager;
    }

    public void destroy() throws Exception {
        if (this.createdTransactionLog && this.transactionLog instanceof HOWLLog) {
            ((HOWLLog)this.transactionLog).doStop();
        }
    }

    public Class getObjectType() {
        return GeronimoPlatformTransactionManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setDefaultTransactionTimeoutSeconds(int timeout) {
        this.defaultTransactionTimeoutSeconds = timeout;
    }

    public void setTransactionLog(TransactionLog log) {
        this.transactionLog = log;
    }

    public String getTransactionLogDir() {
        return this.transactionLogDir;
    }

    public void setTransactionLogDir(String transactionLogDir) {
        this.transactionLogDir = transactionLogDir;
    }

    public Collection getResourceManagers() {
        return this.resourceManagers;
    }

    public XidFactory getXidFactory() {
        return this.xidFactory;
    }

    public void setXidFactory(XidFactory xidFactory) {
        this.xidFactory = xidFactory;
    }

    public void setResourceManagers(Collection resourceManagers) {
        this.resourceManagers = resourceManagers;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.transactionLog == null) {
            this.transactionLog = GeronimoDefaults.createTransactionLog(this.xidFactory, this.transactionLogDir);
            this.createdTransactionLog = true;
        }
        if (this.xidFactory == null) {
            this.xidFactory = new XidFactoryImpl();
        }
    }
}

