/*
 * Decompiled with CFR 0.152.
 */
package org.jencks.factory;

import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import org.apache.geronimo.connector.work.GeronimoWorkManager;
import org.apache.geronimo.transaction.manager.GeronimoTransactionManager;
import org.apache.geronimo.transaction.manager.XAWork;
import org.jencks.factory.GeronimoDefaults;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class WorkManagerFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    private GeronimoWorkManager workManager;
    private GeronimoTransactionManager transactionManager;
    private Executor threadPool;
    private int threadPoolSize;

    public Object getObject() throws Exception {
        if (this.workManager == null) {
            this.workManager = new GeronimoWorkManager(this.threadPool, this.threadPool, this.threadPool, (XAWork)this.transactionManager);
            this.workManager.doStart();
        }
        return this.workManager;
    }

    public Class getObjectType() {
        return GeronimoWorkManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws Exception {
        if (this.workManager != null) {
            this.workManager.doStop();
            this.workManager = null;
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.transactionManager == null) {
            throw new FatalBeanException("Geronimo transaction manager was not set");
        }
        if (this.threadPool == null) {
            this.threadPool = GeronimoDefaults.createThreadPool(this.getThreadPoolSize());
        }
    }

    public GeronimoTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(GeronimoTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public Executor getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(Executor threadPool) {
        this.threadPool = threadPool;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }
}

