/*
 * Decompiled with CFR 0.152.
 */
package org.jencks.pool;

import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.XAConnection;
import javax.jms.XASession;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jencks.pool.PooledSpringXAConnectionFactory;
import org.jencks.pool.PooledSpringXASession;
import org.jencks.pool.XASessionPool;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class PooledSpringXAConnection
implements TopicConnection,
QueueConnection,
XAConnection {
    private static final Log log = LogFactory.getLog((Class)PooledSpringXAConnection.class);
    private final ConnectionInfo connectionInfo;
    private XASessionPool sessionPool;
    private TransactionManager transactionManager;
    private boolean stopped;
    private boolean closed;
    private boolean clientIdSetSinceReopen = false;
    private PooledSpringXAConnectionFactory pooledConnectionFactory;

    public PooledSpringXAConnection(PooledSpringXAConnectionFactory pooledConnectionFactory, TransactionManager transactionManager, XAConnection connection) {
        this(pooledConnectionFactory, transactionManager, new ConnectionInfo(connection), new XASessionPool(connection));
    }

    public PooledSpringXAConnection(PooledSpringXAConnectionFactory pooledConnectionFactory, TransactionManager transactionManager, ConnectionInfo connectionInfo, XASessionPool sessionPool) {
        this.pooledConnectionFactory = pooledConnectionFactory;
        this.transactionManager = transactionManager;
        this.connectionInfo = connectionInfo;
        this.sessionPool = sessionPool;
        this.closed = false;
    }

    public PooledSpringXAConnection newInstance() {
        return new PooledSpringXAConnection(this.pooledConnectionFactory, this.transactionManager, this.connectionInfo, this.sessionPool);
    }

    public void close() throws JMSException {
        this.closed = true;
    }

    public void start() throws JMSException {
        this.getConnection().start();
    }

    public void stop() throws JMSException {
        this.stopped = true;
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String selector, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        return this.getConnection().createConnectionConsumer(destination, selector, serverSessionPool, maxMessages);
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String s, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        return this.getConnection().createConnectionConsumer((Destination)topic, s, serverSessionPool, maxMessages);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String selector, String s1, ServerSessionPool serverSessionPool, int i) throws JMSException {
        return this.getConnection().createDurableConnectionConsumer(topic, selector, s1, serverSessionPool, i);
    }

    public String getClientID() throws JMSException {
        return this.getConnection().getClientID();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        return this.getConnection().getExceptionListener();
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        return this.getConnection().getMetaData();
    }

    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        this.getConnection().setExceptionListener(exceptionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClientID(String clientID) throws JMSException {
        if (this.clientIdSetSinceReopen) {
            throw new JMSException("ClientID is already set on this connection.");
        }
        ConnectionInfo connectionInfo = this.connectionInfo;
        synchronized (connectionInfo) {
            if (this.connectionInfo.isActualClientIdSet()) {
                if (this.connectionInfo.getActualClientIdBase() == null ? clientID != null : !this.connectionInfo.getActualClientIdBase().equals(clientID)) {
                    throw new JMSException("A pooled Connection must only ever have its client ID set to the same value for the duration of the pooled ConnectionFactory.  It looks like code has set a client ID, returned the connection to the pool, and then later obtained the connection from the pool and set a different client ID.");
                }
            } else {
                String generatedId = this.getPooledConnectionFactory().generateClientID(clientID);
                this.getConnection().setClientID(generatedId);
                this.connectionInfo.setActualClientIdBase(clientID);
                this.connectionInfo.setActualClientIdSet(true);
            }
        }
        this.clientIdSetSinceReopen = true;
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String selector, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        return this.getConnection().createConnectionConsumer((Destination)queue, selector, serverSessionPool, maxMessages);
    }

    public XASession createXASession() throws JMSException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"-->> ENTERING PooledSpringXAConnection.createXASession()");
            }
            if (this.transactionManager.getStatus() != 6) {
                XASession session;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"-->> ACTUAL TRANSACTION IS ACTIVE!");
                }
                if ((session = (XASession)TransactionSynchronizationManager.getResource((Object)this.connectionInfo.getConnection())) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"-->> RETURNING ALREADY ACTIVE SESSION ASSOCIATED WITH CURRENT THREAD...");
                    }
                    return session;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"-->> NO ACTIVE SESSION ASSOCIATED WITH CURRENT THREAD, BORROWING...");
                }
                PooledSpringXASession newSession = this.sessionPool.borrowSession();
                newSession.setIgnoreClose(true);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"-->> ENLISTING NEW SESSION'S XAResource WITH TRANSACTION...");
                }
                this.transactionManager.getTransaction().enlistResource(newSession.getXAResource());
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"-->> BINDING NEW SESSION WITH TRANSACTION...");
                    }
                    TransactionSynchronizationManager.bindResource((Object)this.connectionInfo.getConnection(), (Object)newSession);
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"-->> REGISTERING SYNCHRONIZATION WITH TRANSACTION...");
                        }
                        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new Synchronization(newSession));
                        return newSession;
                    }
                    catch (Throwable t) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"-->> CAUGHT EXCEPTION WHILE ASSOCIATING SESSION WITH TRANSACTION, UNBINDING RESOURCE.", t);
                        }
                        TransactionSynchronizationManager.unbindResource((Object)this.connectionInfo.getConnection());
                        newSession.setIgnoreClose(false);
                        throw t;
                    }
                }
                catch (Throwable t) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"-->> CAUGHT EXCEPTION WHILE ASSOCIATING SESSION WITH TRANSACTION (2), DELISTING RESOURCE...", t);
                    }
                    this.transactionManager.getTransaction().delistResource(newSession.getXAResource(), 0x4000000);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"-->> DESTROYING SESSION AND REMOVING FROM POOL...");
                    }
                    newSession.destroyAndRemoveFromPool();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"-->> RETHROWING EXCEPTION...");
                    }
                    if (t instanceof JMSException) {
                        throw (JMSException)t;
                    }
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    if (t instanceof Error) {
                        throw (Error)t;
                    }
                    JMSException jmsException = new JMSException("Unable to enlist session with transaction.");
                    jmsException.initCause(t);
                    throw jmsException;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"-->> THERE IS NO ACTIVE TRANSACTION, SO JUST RETURNING BORROWED SESSION...");
            }
            return this.sessionPool.borrowSession();
        }
        catch (SystemException e) {
            JMSException jmsException = new JMSException("System Exception");
            jmsException.initCause((Throwable)e);
            throw jmsException;
        }
        catch (RollbackException re) {
            JMSException jmsException = new JMSException("Rollback exception");
            jmsException.initCause((Throwable)re);
            throw jmsException;
        }
    }

    public QueueSession createQueueSession(boolean transacted, int ackMode) throws JMSException {
        return (QueueSession)this.createSession(transacted, ackMode);
    }

    public TopicSession createTopicSession(boolean transacted, int ackMode) throws JMSException {
        return (TopicSession)this.createSession(transacted, ackMode);
    }

    public Session createSession(boolean transacted, int ackMode) throws JMSException {
        return this.createXASession();
    }

    protected XAConnection getConnection() throws JMSException {
        if (this.stopped || this.closed) {
            throw new JMSException("Already closed");
        }
        return this.connectionInfo.getConnection();
    }

    public PooledSpringXAConnectionFactory getPooledConnectionFactory() {
        return this.pooledConnectionFactory;
    }

    private static class ConnectionInfo {
        private XAConnection connection;
        private boolean actualClientIdSet;
        private String actualClientIdBase;

        public ConnectionInfo(XAConnection connection) {
            this.connection = connection;
            this.actualClientIdSet = false;
            this.actualClientIdBase = null;
        }

        public XAConnection getConnection() {
            return this.connection;
        }

        public void setConnection(XAConnection connection) {
            this.connection = connection;
        }

        public synchronized boolean isActualClientIdSet() {
            return this.actualClientIdSet;
        }

        public synchronized void setActualClientIdSet(boolean actualClientIdSet) {
            this.actualClientIdSet = actualClientIdSet;
        }

        public synchronized String getActualClientIdBase() {
            return this.actualClientIdBase;
        }

        public synchronized void setActualClientIdBase(String actualClientIdBase) {
            this.actualClientIdBase = actualClientIdBase;
        }
    }

    private class Synchronization
    implements TransactionSynchronization {
        private final PooledSpringXASession session;

        private Synchronization(PooledSpringXASession session) {
            this.session = session;
        }

        public void suspend() {
            if (log.isDebugEnabled()) {
                log.debug((Object)"-->> PooledSpringXAConnection.[synchronization].suspend() CALLED...");
            }
            TransactionSynchronizationManager.unbindResource((Object)PooledSpringXAConnection.this.connectionInfo.getConnection());
        }

        public void resume() {
            if (log.isDebugEnabled()) {
                log.debug((Object)"-->> PooledSpringXAConnection.[synchronization].resume() CALLED...");
            }
            TransactionSynchronizationManager.bindResource((Object)PooledSpringXAConnection.this.connectionInfo.getConnection(), (Object)this.session);
        }

        public void beforeCommit(boolean readOnly) {
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"-->> PooledSpringXAConnection.[synchronization].afterCompletion() CALLED...");
            }
            TransactionSynchronizationManager.unbindResource((Object)PooledSpringXAConnection.this.connectionInfo.getConnection());
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"-->> RETURNING JMS SESSION TO POOL...");
                }
                this.session.setIgnoreClose(false);
                this.session.close();
            }
            catch (JMSException e) {
                throw new RuntimeException(e);
            }
        }

        public void afterCommit() {
        }
    }
}

