/*
 * Decompiled with CFR 0.152.
 */
package org.jencks.pool;

import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XASession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.jencks.pool.PooledSpringXASession;

public class XASessionPool
implements PoolableObjectFactory {
    private static final Log log = LogFactory.getLog((Class)XASessionPool.class);
    private XAConnection connection;
    private ObjectPool sessionPool;

    public XASessionPool(XAConnection connection) {
        this(connection, (ObjectPool)new GenericObjectPool(null, -1));
    }

    public XASessionPool(XAConnection connection, ObjectPool sessionPool) {
        this.connection = connection;
        this.sessionPool = sessionPool;
        sessionPool.setFactory((PoolableObjectFactory)this);
    }

    public PooledSpringXASession borrowSession() throws JMSException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"---->>>>> BORROWING JMS SESSION FROM POOL...");
            }
            Object object = this.sessionPool.borrowObject();
            if (log.isDebugEnabled()) {
                log.debug((Object)("---->>>>> BORROWED SESSION: " + object));
            }
            return (PooledSpringXASession)object;
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Exception e) {
            JMSException jmsException = new JMSException("Unhandled exception");
            jmsException.initCause((Throwable)e);
            throw jmsException;
        }
    }

    public Object makeObject() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"---->>>>> CREATING NEW SESSION TO SATISFY REQUEST!!");
        }
        return new PooledSpringXASession(this.createSession(), this.sessionPool);
    }

    public void destroyObject(Object o) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("---->>>>> DESTROYING SESSION AND PERMANENTLY REMOVING FROM POOL: " + o));
        }
        PooledSpringXASession session = (PooledSpringXASession)o;
        session.getActualSession().close();
    }

    public boolean validateObject(Object o) {
        return true;
    }

    public void activateObject(Object o) throws Exception {
    }

    public void passivateObject(Object o) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("---->>>>> SESSION HAS BEEN RETURNED TO POOL: " + o));
        }
    }

    protected XAConnection getConnection() throws JMSException {
        if (this.connection == null) {
            throw new JMSException("Already closed");
        }
        return this.connection;
    }

    protected XASession createSession() throws JMSException {
        return this.getConnection().createXASession();
    }
}

