/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.jbi.component.ComponentContext;
import javax.jbi.component.ComponentLifeCycle;
import javax.jbi.component.ServiceUnitManager;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.common.BaseLifeCycle;
import org.apache.servicemix.common.BaseServiceUnitManager;
import org.apache.servicemix.common.Deployer;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.EndpointSupport;
import org.apache.servicemix.common.Registry;
import org.apache.servicemix.common.ResolvedEndpoint;
import org.apache.servicemix.common.ServiceMixComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.xbean.BaseXBeanDeployer;
import org.apache.servicemix.common.xbean.XBeanServiceUnit;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public abstract class DefaultComponent
extends BaseLifeCycle
implements ServiceMixComponent {
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    protected Registry registry;
    protected BaseServiceUnitManager serviceUnitManager;
    protected ServiceUnit serviceUnit;

    public DefaultComponent() {
        this.setComponent(this);
        this.registry = this.createRegistry();
        this.serviceUnitManager = this.createServiceUnitManager();
    }

    public ComponentLifeCycle getLifeCycle() {
        return this;
    }

    public ServiceUnitManager getServiceUnitManager() {
        return this.serviceUnitManager;
    }

    public Document getServiceDescription(ServiceEndpoint endpoint) {
        String key;
        Endpoint ep;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Querying service description for " + endpoint));
        }
        if ((ep = this.registry.getEndpoint(key = EndpointSupport.getKey(endpoint))) != null) {
            Document doc = ep.getDescription();
            if (doc == null && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No description found for " + key));
            }
            return doc;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("No endpoint found for " + key));
        }
        return null;
    }

    public boolean isExchangeWithConsumerOkay(ServiceEndpoint endpoint, MessageExchange exchange) {
        String key = EndpointSupport.getKey(endpoint);
        Endpoint ep = this.registry.getEndpoint(key);
        if (ep != null) {
            if (ep.getRole() != MessageExchange.Role.PROVIDER) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Endpoint " + key + " is a consumer. Refusing exchange with consumer."));
                }
                return false;
            }
            return ep.isExchangeOkay(exchange);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("No endpoint found for " + key + ". Refusing exchange with consumer."));
        }
        return false;
    }

    public boolean isExchangeWithProviderOkay(ServiceEndpoint endpoint, MessageExchange exchange) {
        return true;
    }

    public QName getEPRServiceName() {
        return new QName(this.getEPRUri(), this.getEPRComponentName());
    }

    public QName getEPRElementName() {
        return new QName(this.getEPRUri(), "epr");
    }

    protected String[] getEPRProtocols() {
        String protocol = this.getEPRStrippedComponentName().toLowerCase() + ":";
        return new String[]{protocol};
    }

    private String getEPRComponentName() {
        String suffix = this.getClass().getName();
        if ((suffix = suffix.substring(suffix.lastIndexOf(46) + 1)).lastIndexOf(36) > 0) {
            suffix = suffix.substring(suffix.lastIndexOf(36) + 1);
        }
        return suffix;
    }

    private String getEPRStrippedComponentName() {
        String suffix = this.getEPRComponentName();
        if (suffix.endsWith("Component")) {
            suffix = suffix.substring(0, suffix.length() - 9);
        }
        return suffix;
    }

    private String getEPRUri() {
        String uri = "urn:servicemix:" + this.getEPRStrippedComponentName().toLowerCase();
        return uri;
    }

    public ServiceEndpoint resolveEndpointReference(DocumentFragment epr) {
        String[] protocols = this.getEPRProtocols();
        QName elementName = this.getEPRElementName();
        QName serviceName = this.getEPRServiceName();
        for (int i = 0; i < protocols.length; ++i) {
            ServiceEndpoint ep = ResolvedEndpoint.resolveEndpoint(epr, elementName, serviceName, protocols[i]);
            if (ep == null) continue;
            return ep;
        }
        return null;
    }

    protected BaseServiceUnitManager createServiceUnitManager() {
        Class[] classes = this.getEndpointClasses();
        if (classes == null) {
            return null;
        }
        Deployer[] deployers = new Deployer[]{new BaseXBeanDeployer((ServiceMixComponent)this, classes)};
        return new BaseServiceUnitManager(this, deployers);
    }

    protected Registry createRegistry() {
        return new Registry(this);
    }

    public ComponentContext getComponentContext() {
        return this.getContext();
    }

    public String getComponentName() {
        if (this.getComponentContext() == null) {
            return "Component (" + this.getClass().getName() + ") not yet initialized";
        }
        return this.getComponentContext().getComponentName();
    }

    public Log getLogger() {
        return this.logger;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public ServiceUnit getServiceUnit() {
        if (this.serviceUnit == null) {
            this.serviceUnit = new XBeanServiceUnit();
            this.serviceUnit.setName("#default#");
            this.serviceUnit.setComponent(this);
        }
        return this.serviceUnit;
    }

    protected abstract List getConfiguredEndpoints();

    protected abstract Class[] getEndpointClasses();

    protected static List asList(Object[] endpoints) {
        if (endpoints == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(endpoints);
    }

    protected void doInit() throws Exception {
        super.doInit();
        List endpoints = this.getConfiguredEndpoints();
        if (endpoints != null && !endpoints.isEmpty()) {
            for (Endpoint endpoint : endpoints) {
                if (endpoint == null) {
                    this.logger.warn((Object)("Ignoring null endpoint in list: " + endpoints));
                    continue;
                }
                this.addEndpoint(endpoint);
            }
        }
    }

    public void addEndpoint(Endpoint endpoint) throws Exception {
        ServiceUnit su = this.getServiceUnit();
        endpoint.setServiceUnit(su);
        this.validateEndpoint(endpoint);
        endpoint.validate();
        su.addEndpoint(endpoint);
        if (this.registry.isRegistered(su)) {
            this.registry.registerEndpoint(endpoint);
        } else {
            this.registry.registerServiceUnit(su);
            if (this.isStarted()) {
                su.start();
            }
        }
    }

    protected void validateEndpoint(Endpoint endpoint) throws DeploymentException {
        Class[] endpointClasses = this.getEndpointClasses();
        if (endpointClasses != null) {
            boolean valid = false;
            for (int i = 0; i < endpointClasses.length; ++i) {
                Class endpointClass = endpointClasses[i];
                if (!endpointClass.isInstance(endpoint)) continue;
                valid = true;
            }
            if (!valid) {
                throw new DeploymentException("The endpoint: " + endpoint + " is not an instance of any of the allowable types: " + Arrays.asList(endpointClasses));
            }
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.serviceUnit != null) {
            if (!this.registry.isRegistered(this.serviceUnit)) {
                this.registry.registerServiceUnit(this.serviceUnit);
            }
            this.serviceUnit.start();
        }
    }

    protected void doStop() throws Exception {
        if (this.serviceUnit != null) {
            this.serviceUnit.stop();
        }
        super.doStop();
    }

    protected void doShutDown() throws Exception {
        if (this.serviceUnit != null) {
            this.serviceUnit.shutDown();
        }
        super.doShutDown();
    }
}

