/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common.xbean;

import javax.jbi.JBIException;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.xbean.kernel.Kernel;
import org.apache.xbean.kernel.ServiceFactory;
import org.apache.xbean.kernel.ServiceName;
import org.apache.xbean.kernel.ServiceNotFoundException;

public class XBeanServiceUnit
extends ServiceUnit {
    private Kernel kernel;
    private ServiceName configuration;
    private ClassLoader classLoader;

    public Kernel getKernel() {
        return this.kernel;
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public ServiceName getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ServiceName configuration) {
        this.configuration = configuration;
    }

    public void shutDown() throws JBIException {
        super.shutDown();
        this.classLoader = null;
        if (this.kernel != null) {
            this.kernel.destroy();
        }
    }

    public ClassLoader getConfigurationClassLoader() {
        ClassLoader cl;
        if (this.classLoader == null && this.kernel != null && this.configuration != null) {
            try {
                ServiceFactory sf = this.kernel.getServiceFactory(this.configuration);
                this.classLoader = sf.getClassLoader();
            }
            catch (ServiceNotFoundException e) {
                // empty catch block
            }
        }
        if ((cl = this.classLoader) == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        return cl;
    }
}

