/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jbi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jbi.management.DeploymentException;
import org.apache.camel.Endpoint;
import org.apache.camel.component.jbi.CamelJbiComponent;
import org.apache.camel.component.jbi.CamelJbiEndpoint;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.servicemix.common.ServiceMixComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.xbean.AbstractXBeanDeployer;
import org.apache.xbean.kernel.Kernel;
import org.apache.xbean.server.spring.loader.PureSpringLoader;
import org.apache.xbean.server.spring.loader.SpringLoader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

public class CamelSpringDeployer
extends AbstractXBeanDeployer {
    private final CamelJbiComponent component;
    private PureSpringLoader springLoader = new PureSpringLoader(){

        protected AbstractXmlApplicationContext createXmlApplicationContext(String configLocation) {
            return new FileSystemXmlApplicationContext(new String[]{configLocation}, false, CamelSpringDeployer.this.createParentApplicationContext());
        }
    };
    private List<CamelJbiEndpoint> activatedEndpoints = new ArrayList<CamelJbiEndpoint>();

    public CamelSpringDeployer(CamelJbiComponent component) {
        super((ServiceMixComponent)component);
        this.component = component;
    }

    protected String getXBeanFile() {
        return "camel-context";
    }

    public ServiceUnit deploy(String serviceUnitName, String serviceUnitRootPath) throws DeploymentException {
        this.component.deployer = this;
        ServiceUnit serviceUnit = super.deploy(serviceUnitName, serviceUnitRootPath);
        return serviceUnit;
    }

    public void addService(CamelJbiEndpoint endpoint) {
        this.activatedEndpoints.add(endpoint);
    }

    protected List getServices(Kernel kernel) {
        try {
            ArrayList<CamelJbiEndpoint> services = new ArrayList<CamelJbiEndpoint>(this.activatedEndpoints);
            this.activatedEndpoints.clear();
            AbstractXmlApplicationContext applicationContext = this.springLoader.getApplicationContext();
            SpringCamelContext camelContext = SpringCamelContext.springCamelContext((ApplicationContext)applicationContext);
            Collection endpoints = camelContext.getSingletonEndpoints();
            for (Endpoint endpoint : endpoints) {
                if (!this.component.isEndpointExposedOnNmr(endpoint)) continue;
                services.add(this.component.createJbiEndpointFromCamel(endpoint));
            }
            return services;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected SpringLoader createSpringLoader() {
        return this.springLoader;
    }

    protected ApplicationContext createParentApplicationContext() {
        GenericApplicationContext answer = new GenericApplicationContext();
        answer.getBeanFactory().registerSingleton("jbi", (Object)this.component);
        answer.start();
        answer.refresh();
        return answer;
    }
}

