/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jbi;

import java.util.Iterator;
import java.util.Map;
import javax.jbi.messaging.NormalizedMessage;
import org.apache.camel.component.jbi.JbiExchange;
import org.apache.camel.impl.DefaultMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JbiMessage
extends DefaultMessage {
    private NormalizedMessage normalizedMessage;

    public JbiMessage() {
    }

    public JbiMessage(NormalizedMessage normalizedMessage) {
        this.normalizedMessage = normalizedMessage;
    }

    public String toString() {
        if (this.normalizedMessage != null) {
            return "JbiMessage: " + this.normalizedMessage;
        }
        return "JbiMessage: " + this.getBody();
    }

    public JbiExchange getExchange() {
        return (JbiExchange)super.getExchange();
    }

    public NormalizedMessage getNormalizedMessage() {
        return this.normalizedMessage;
    }

    public void setNormalizedMessage(NormalizedMessage normalizedMessage) {
        this.normalizedMessage = normalizedMessage;
    }

    public Object getHeader(String name) {
        Object answer = null;
        if (this.normalizedMessage != null) {
            answer = this.normalizedMessage.getProperty(name);
        }
        if (answer == null) {
            answer = super.getHeader(name);
        }
        return answer;
    }

    public JbiMessage newInstance() {
        return new JbiMessage();
    }

    protected Object createBody() {
        if (this.normalizedMessage != null) {
            return this.getExchange().getBinding().extractBodyFromJbi(this.getExchange(), this.normalizedMessage);
        }
        return null;
    }

    protected void populateInitialHeaders(Map<String, Object> map) {
        if (this.normalizedMessage != null) {
            Iterator iter = this.normalizedMessage.getPropertyNames().iterator();
            while (iter.hasNext()) {
                String name = iter.next().toString();
                Object value = this.normalizedMessage.getProperty(name);
                map.put(name, value);
            }
        }
    }
}

