/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcr;

import java.net.URI;
import java.net.URISyntaxException;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.SimpleCredentials;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.jcr.JcrComponent;
import org.apache.camel.component.jcr.JcrConsumer;
import org.apache.camel.component.jcr.JcrProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;

public class JcrEndpoint
extends DefaultEndpoint {
    private Credentials credentials;
    private Repository repository;
    private String base;
    private int eventTypes;
    private boolean deep;
    private String uuids;
    private String nodeTypeNames;
    private boolean noLocal;
    private long sessionLiveCheckIntervalOnStart = 3000L;
    private long sessionLiveCheckInterval = 60000L;

    protected JcrEndpoint(String endpointUri, JcrComponent component) {
        super(endpointUri, (Component)component);
        try {
            String[] creds;
            URI uri = new URI(endpointUri);
            if (uri.getUserInfo() != null && (creds = uri.getUserInfo().split(":")) != null) {
                String username = creds[0];
                String password = creds.length > 1 ? creds[1] : null;
                this.credentials = new SimpleCredentials(username, password.toCharArray());
            }
            this.repository = (Repository)component.getCamelContext().getRegistry().lookupByNameAndType(uri.getHost(), Repository.class);
            if (this.repository == null) {
                throw new RuntimeCamelException("No JCR repository defined under '" + uri.getHost() + "'");
            }
            this.base = uri.getPath().replaceAll("^/", "");
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI: " + endpointUri, e);
        }
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        JcrConsumer answer = new JcrConsumer(this, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public Producer createProducer() throws Exception {
        return new JcrProducer(this);
    }

    public boolean isSingleton() {
        return true;
    }

    protected Repository getRepository() {
        return this.repository;
    }

    protected Credentials getCredentials() {
        return this.credentials;
    }

    protected String getBase() {
        return this.base;
    }

    public int getEventTypes() {
        return this.eventTypes;
    }

    public void setEventTypes(int eventTypes) {
        this.eventTypes = eventTypes;
    }

    public boolean isDeep() {
        return this.deep;
    }

    public void setDeep(boolean deep) {
        this.deep = deep;
    }

    public String getUuids() {
        return this.uuids;
    }

    public void setUuids(String uuids) {
        this.uuids = uuids;
    }

    public String getNodeTypeNames() {
        return this.nodeTypeNames;
    }

    public void setNodeTypeNames(String nodeTypeNames) {
        this.nodeTypeNames = nodeTypeNames;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
    }

    public long getSessionLiveCheckIntervalOnStart() {
        return this.sessionLiveCheckIntervalOnStart;
    }

    public void setSessionLiveCheckIntervalOnStart(long sessionLiveCheckIntervalOnStart) {
        if (sessionLiveCheckIntervalOnStart <= 0L) {
            throw new IllegalArgumentException("sessionLiveCheckIntervalOnStart must be positive value");
        }
        this.sessionLiveCheckIntervalOnStart = sessionLiveCheckIntervalOnStart;
    }

    public long getSessionLiveCheckInterval() {
        return this.sessionLiveCheckInterval;
    }

    public void setSessionLiveCheckInterval(long sessionLiveCheckInterval) {
        if (sessionLiveCheckInterval <= 0L) {
            throw new IllegalArgumentException("sessionLiveCheckInterval must be positive value");
        }
        this.sessionLiveCheckInterval = sessionLiveCheckInterval;
    }

    public String getEndpointConfiguredDestinationName() {
        String remainder = ObjectHelper.after((String)this.getEndpointKey(), (String)"//");
        if (remainder != null && remainder.contains("@")) {
            remainder = remainder.substring(remainder.indexOf(64));
        }
        if (remainder != null && remainder.contains("?")) {
            remainder = ObjectHelper.before((String)remainder, (String)"?");
        }
        if (ObjectHelper.isEmpty((Object)remainder)) {
            return remainder;
        }
        return remainder;
    }
}

