/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcr;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.jcr.JcrEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.jackrabbit.util.Text;

public class JcrProducer
extends DefaultProducer {
    public JcrProducer(JcrEndpoint jcrEndpoint) throws RepositoryException {
        super((Endpoint)jcrEndpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        Session session = this.openSession();
        try {
            Node base = this.findOrCreateNode(session.getRootNode(), this.getJcrEndpoint().getBase());
            Node node = this.findOrCreateNode(base, this.getNodeName(exchange));
            TypeConverter converter = exchange.getContext().getTypeConverter();
            for (String key : exchange.getProperties().keySet()) {
                Value value = (Value)converter.convertTo(Value.class, exchange, exchange.getProperty(key));
                node.setProperty(key, value);
            }
            node.addMixin("mix:referenceable");
            session.save();
            exchange.getOut().setBody((Object)node.getUUID());
        }
        finally {
            if (session != null && session.isLive()) {
                session.logout();
            }
        }
    }

    private String getNodeName(Exchange exchange) {
        if (exchange.getProperty("CamelJcrNodeName") != null) {
            return (String)exchange.getProperty("CamelJcrNodeName", String.class);
        }
        return exchange.getExchangeId();
    }

    private Node findOrCreateNode(Node parent, String path) throws RepositoryException {
        Node result = parent;
        for (String component : path.split("/")) {
            if ((component = Text.escapeIllegalJcrChars((String)component)).length() <= 0 || result.hasNode(component)) continue;
            result = result.addNode(component);
        }
        return result;
    }

    protected Session openSession() throws RepositoryException {
        return this.getJcrEndpoint().getRepository().login(this.getJcrEndpoint().getCredentials());
    }

    private JcrEndpoint getJcrEndpoint() {
        JcrEndpoint endpoint = (JcrEndpoint)this.getEndpoint();
        return endpoint;
    }
}

