/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jdbc.aggregationrepository;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.jdbc.aggregationrepository.ClassLoadingAwareObjectInputStream;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultExchangeHolder;

public final class JdbcCamelCodec {
    public byte[] marshallExchange(CamelContext camelContext, Exchange exchange) throws IOException {
        DefaultExchangeHolder pe = DefaultExchangeHolder.marshal((Exchange)exchange, (boolean)false);
        DefaultExchangeHolder.addProperty((DefaultExchangeHolder)pe, (String)"CamelAggregatedSize", (Serializable)((Serializable)exchange.getProperty("CamelAggregatedSize", Integer.class)));
        DefaultExchangeHolder.addProperty((DefaultExchangeHolder)pe, (String)"CamelAggregatedCompletedBy", (Serializable)((Serializable)exchange.getProperty("CamelAggregatedCompletedBy", String.class)));
        DefaultExchangeHolder.addProperty((DefaultExchangeHolder)pe, (String)"CamelAggregatedCorrelationKey", (Serializable)((Serializable)exchange.getProperty("CamelAggregatedCorrelationKey", String.class)));
        if (exchange.getFromEndpoint() != null) {
            DefaultExchangeHolder.addProperty((DefaultExchangeHolder)pe, (String)"CamelAggregatedFromEndpoint", (Serializable)((Object)exchange.getFromEndpoint().getEndpointUri()));
        }
        return this.encode(pe);
    }

    public Exchange unmarshallExchange(CamelContext camelContext, byte[] buffer) throws IOException, ClassNotFoundException {
        Endpoint fromEndpoint;
        DefaultExchangeHolder pe = this.decode(buffer);
        DefaultExchange answer = new DefaultExchange(camelContext);
        DefaultExchangeHolder.unmarshal((Exchange)answer, (DefaultExchangeHolder)pe);
        String fromEndpointUri = (String)answer.removeProperty("CamelAggregatedFromEndpoint");
        if (fromEndpointUri != null && (fromEndpoint = camelContext.hasEndpoint(fromEndpointUri)) != null) {
            answer.setFromEndpoint(fromEndpoint);
        }
        return answer;
    }

    private byte[] encode(Object object) throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        ObjectOutputStream objectOut = new ObjectOutputStream(bytesOut);
        objectOut.writeObject(object);
        objectOut.close();
        byte[] data = bytesOut.toByteArray();
        return data;
    }

    private DefaultExchangeHolder decode(byte[] dataIn) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(dataIn);
        ClassLoadingAwareObjectInputStream objectIn = new ClassLoadingAwareObjectInputStream(bytesIn);
        Object obj = objectIn.readObject();
        return (DefaultExchangeHolder)obj;
    }
}

