/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.management.MBeanServer;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.http.CamelServlet;
import org.apache.camel.component.http.HttpBinding;
import org.apache.camel.component.http.HttpComponent;
import org.apache.camel.component.http.HttpConsumer;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.http.ServletResolveConsumerStrategy;
import org.apache.camel.component.http.UrlRewrite;
import org.apache.camel.component.jetty.CamelContinuationServlet;
import org.apache.camel.component.jetty.CamelFilterWrapper;
import org.apache.camel.component.jetty.CamelHttpClient;
import org.apache.camel.component.jetty.JettyHttpBinding;
import org.apache.camel.component.jetty.JettyHttpEndpoint;
import org.apache.camel.component.jetty.JettyRestHttpBinding;
import org.apache.camel.component.jetty.JettyRestServletResolveConsumerStrategy;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.ManagementAgent;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestConsumerFactory;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.HostUtils;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.servlets.MultiPartFilter;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JettyHttpComponent
extends HttpComponent
implements RestConsumerFactory {
    public static final String TMP_DIR = "CamelJettyTempDir";
    protected static final HashMap<String, ConnectorRef> CONNECTORS = new HashMap();
    private static final Logger LOG = LoggerFactory.getLogger(JettyHttpComponent.class);
    private static final String JETTY_SSL_KEYSTORE = "org.eclipse.jetty.ssl.keystore";
    private static final String JETTY_SSL_KEYPASSWORD = "org.eclipse.jetty.ssl.keypassword";
    private static final String JETTY_SSL_PASSWORD = "org.eclipse.jetty.ssl.password";
    protected String sslKeyPassword;
    protected String sslPassword;
    protected String sslKeystore;
    protected Map<Integer, Connector> sslSocketConnectors;
    protected Map<Integer, Connector> socketConnectors;
    protected Map<String, Object> sslSocketConnectorProperties;
    protected Map<String, Object> socketConnectorProperties;
    protected Integer httpClientMinThreads;
    protected Integer httpClientMaxThreads;
    protected Integer minThreads;
    protected Integer maxThreads;
    protected ThreadPool threadPool;
    protected MBeanContainer mbContainer;
    protected boolean enableJmx;
    protected JettyHttpBinding jettyHttpBinding;
    protected Long continuationTimeout;
    protected boolean useContinuation = true;
    protected SSLContextParameters sslContextParameters;
    protected Integer requestBufferSize;
    protected Integer requestHeaderSize;
    protected Integer responseBufferSize;
    protected Integer responseHeaderSize;
    protected String proxyHost;
    protected ErrorHandler errorHandler;
    private Integer proxyPort;

    public JettyHttpComponent() {
        super(JettyHttpEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        List handlerList = this.resolveAndRemoveReferenceListParameter(parameters, "handlers", Handler.class);
        HttpBinding binding = (HttpBinding)this.resolveAndRemoveReferenceParameter(parameters, "httpBindingRef", HttpBinding.class);
        JettyHttpBinding jettyBinding = (JettyHttpBinding)this.resolveAndRemoveReferenceParameter(parameters, "jettyHttpBindingRef", JettyHttpBinding.class);
        Boolean throwExceptionOnFailure = (Boolean)this.getAndRemoveParameter(parameters, "throwExceptionOnFailure", Boolean.class);
        Boolean transferException = (Boolean)this.getAndRemoveParameter(parameters, "transferException", Boolean.class);
        Boolean bridgeEndpoint = (Boolean)this.getAndRemoveParameter(parameters, "bridgeEndpoint", Boolean.class);
        Boolean matchOnUriPrefix = (Boolean)this.getAndRemoveParameter(parameters, "matchOnUriPrefix", Boolean.class);
        Boolean enableJmx = (Boolean)this.getAndRemoveParameter(parameters, "enableJmx", Boolean.class);
        Boolean enableMultipartFilter = (Boolean)this.getAndRemoveParameter(parameters, "enableMultipartFilter", Boolean.class, true);
        Filter multipartFilter = (Filter)this.resolveAndRemoveReferenceParameter(parameters, "multipartFilterRef", Filter.class);
        ArrayList<CrossOriginFilter> filters = this.resolveAndRemoveReferenceListParameter(parameters, "filtersRef", Filter.class);
        Boolean enableCors = (Boolean)this.getAndRemoveParameter(parameters, "enableCORS", Boolean.class, false);
        Long continuationTimeout = (Long)this.getAndRemoveParameter(parameters, "continuationTimeout", Long.class);
        Boolean useContinuation = (Boolean)this.getAndRemoveParameter(parameters, "useContinuation", Boolean.class);
        HeaderFilterStrategy headerFilterStrategy = (HeaderFilterStrategy)this.resolveAndRemoveReferenceParameter(parameters, "headerFilterStrategy", HeaderFilterStrategy.class);
        UrlRewrite urlRewrite = (UrlRewrite)this.resolveAndRemoveReferenceParameter(parameters, "urlRewrite", UrlRewrite.class);
        SSLContextParameters sslContextParameters = (SSLContextParameters)this.resolveAndRemoveReferenceParameter(parameters, "sslContextParametersRef", SSLContextParameters.class);
        SSLContextParameters ssl = sslContextParameters != null ? sslContextParameters : this.sslContextParameters;
        String proxyHost = (String)this.getAndRemoveParameter(parameters, "proxyHost", String.class, this.getProxyHost());
        Integer proxyPort = (Integer)this.getAndRemoveParameter(parameters, "proxyPort", Integer.class, this.getProxyPort());
        Integer responseBufferSize = (Integer)this.getAndRemoveParameter(parameters, "responseBufferSize", Integer.class, this.getResponseBufferSize());
        Integer httpClientMinThreads = (Integer)this.getAndRemoveParameter(parameters, "httpClientMinThreads", Integer.class, this.httpClientMinThreads);
        Integer httpClientMaxThreads = (Integer)this.getAndRemoveParameter(parameters, "httpClientMaxThreads", Integer.class, this.httpClientMaxThreads);
        HttpClient httpClient = (HttpClient)this.resolveAndRemoveReferenceParameter(parameters, "httpClient", HttpClient.class);
        Map httpClientParameters = IntrospectionSupport.extractProperties(parameters, (String)"httpClient.");
        String address = remaining;
        URI addressUri = new URI(UnsafeUriCharactersEncoder.encodeHttpURI((String)address));
        URI endpointUri = URISupport.createRemainingURI((URI)addressUri, parameters);
        String httpMethodRestrict = (String)this.getAndRemoveParameter(parameters, "httpMethodRestrict", String.class);
        URI httpUri = URISupport.createRemainingURI((URI)addressUri, parameters);
        JettyHttpEndpoint endpoint = this.createEndpoint(endpointUri, httpUri);
        if (headerFilterStrategy != null) {
            endpoint.setHeaderFilterStrategy(headerFilterStrategy);
        } else {
            this.setEndpointHeaderFilterStrategy((Endpoint)endpoint);
        }
        if (proxyHost != null) {
            endpoint.setProxyHost(proxyHost);
            endpoint.setProxyPort(proxyPort);
        }
        if (urlRewrite != null) {
            this.getCamelContext().addService((Object)urlRewrite);
            endpoint.setUrlRewrite(urlRewrite);
        }
        if (httpClientParameters != null && !httpClientParameters.isEmpty()) {
            endpoint.setHttpClientParameters(httpClientParameters);
        }
        if (handlerList.size() > 0) {
            endpoint.setHandlers(handlerList);
        }
        if (binding == null) {
            binding = this.getHttpBinding();
        }
        if (binding != null) {
            endpoint.setBinding(binding);
        }
        if (jettyBinding == null) {
            jettyBinding = this.getJettyHttpBinding();
        }
        if (jettyBinding != null) {
            endpoint.setJettyBinding(jettyBinding);
        }
        if (throwExceptionOnFailure != null) {
            endpoint.setThrowExceptionOnFailure(throwExceptionOnFailure);
        }
        if (transferException != null) {
            endpoint.setTransferException(transferException);
        }
        if (bridgeEndpoint != null) {
            endpoint.setBridgeEndpoint(bridgeEndpoint);
        }
        if (matchOnUriPrefix != null) {
            endpoint.setMatchOnUriPrefix(matchOnUriPrefix);
        }
        if (enableJmx != null) {
            endpoint.setEnableJmx(enableJmx);
        } else {
            endpoint.setEnableJmx(this.isEnableJmx());
        }
        endpoint.setEnableMultipartFilter(enableMultipartFilter);
        if (multipartFilter != null) {
            endpoint.setMultipartFilter(multipartFilter);
            endpoint.setEnableMultipartFilter(true);
        }
        if (enableCors.booleanValue()) {
            if (filters == null) {
                filters = new ArrayList<CrossOriginFilter>(1);
            }
            filters.add(new CrossOriginFilter());
        }
        if (filters != null) {
            endpoint.setFilters((List<Filter>)filters);
        }
        if (continuationTimeout != null) {
            endpoint.setContinuationTimeout(continuationTimeout);
        }
        if (useContinuation != null) {
            endpoint.setUseContinuation(useContinuation);
        }
        if (httpMethodRestrict != null) {
            endpoint.setHttpMethodRestrict(httpMethodRestrict);
        }
        if (ssl != null) {
            endpoint.setSslContextParameters(ssl);
        }
        if (responseBufferSize != null) {
            endpoint.setResponseBufferSize(responseBufferSize);
        }
        if (httpClientMinThreads != null) {
            endpoint.setHttpClientMinThreads(httpClientMinThreads);
        }
        if (httpClientMaxThreads != null) {
            endpoint.setHttpClientMaxThreads(httpClientMaxThreads);
        }
        if (httpClient != null) {
            endpoint.setHttpClient(httpClient);
        }
        this.setProperties((Object)endpoint, parameters);
        return endpoint;
    }

    protected abstract JettyHttpEndpoint createEndpoint(URI var1, URI var2) throws URISyntaxException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(HttpConsumer consumer) throws Exception {
        JettyHttpEndpoint endpoint = (JettyHttpEndpoint)consumer.getEndpoint();
        String connectorKey = this.getConnectorKey(endpoint);
        HashMap<String, ConnectorRef> hashMap = CONNECTORS;
        synchronized (hashMap) {
            ConnectorRef connectorRef = CONNECTORS.get(connectorKey);
            if (connectorRef == null) {
                Server server = this.createServer();
                Connector connector = this.getConnector(server, endpoint);
                if ("localhost".equalsIgnoreCase(endpoint.getHttpUri().getHost())) {
                    LOG.warn("You use localhost interface! It means that no external connections will be available. Don't you want to use 0.0.0.0 instead (all network interfaces)? " + (Object)((Object)endpoint));
                }
                if (endpoint.isEnableJmx()) {
                    this.enableJmx(server);
                }
                server.addConnector(connector);
                connectorRef = new ConnectorRef(server, connector, this.createServletForConnector(server, connector, endpoint.getHandlers(), endpoint));
                if (endpoint.isSessionSupport()) {
                    this.enableSessionSupport(connectorRef.server, connectorKey);
                }
                connectorRef.server.start();
                CONNECTORS.put(connectorKey, connectorRef);
            } else {
                if (endpoint.getHandlers() != null && !endpoint.getHandlers().isEmpty()) {
                    this.addJettyHandlers(connectorRef.server, endpoint.getHandlers());
                }
                connectorRef.increment();
            }
            if (endpoint.isSessionSupport()) {
                this.enableSessionSupport(connectorRef.server, connectorKey);
            }
            if (endpoint.isEnableMultipartFilter()) {
                this.enableMultipartFilter(endpoint, connectorRef.server, connectorKey);
            }
            if (endpoint.getFilters() != null && endpoint.getFilters().size() > 0) {
                this.setFilters(endpoint, connectorRef.server, connectorKey);
            }
            connectorRef.servlet.connect(consumer);
        }
    }

    private void enableJmx(Server server) {
        MBeanContainer containerToRegister = this.getMbContainer();
        if (containerToRegister != null) {
            LOG.info("Jetty JMX Extensions is enabled");
            this.addServerMBean(server);
        }
    }

    private void enableSessionSupport(Server server, String connectorKey) throws Exception {
        ServletContextHandler context = (ServletContextHandler)server.getChildHandlerByClass(ServletContextHandler.class);
        if (context.getSessionHandler() == null) {
            SessionHandler sessionHandler = new SessionHandler();
            if (context.isStarted()) {
                throw new IllegalStateException("Server has already been started. Cannot enabled sessionSupport on " + connectorKey);
            }
            context.setSessionHandler(sessionHandler);
        }
    }

    private void setFilters(JettyHttpEndpoint endpoint, Server server, String connectorKey) {
        ServletContextHandler context = (ServletContextHandler)server.getChildHandlerByClass(ServletContextHandler.class);
        List<Filter> filters = endpoint.getFilters();
        for (Filter filter : filters) {
            FilterHolder filterHolder = new FilterHolder();
            filterHolder.setFilter((Filter)new CamelFilterWrapper(filter));
            String pathSpec = endpoint.getPath();
            if (pathSpec == null || "".equals(pathSpec)) {
                pathSpec = "/";
            }
            if (endpoint.isMatchOnUriPrefix()) {
                pathSpec = pathSpec.endsWith("/") ? pathSpec + "*" : pathSpec + "/*";
            }
            this.addFilter(context, filterHolder, pathSpec);
        }
    }

    private void addFilter(ServletContextHandler context, FilterHolder filterHolder, String pathSpec) {
        context.getServletHandler().addFilterWithMapping(filterHolder, pathSpec, 0);
    }

    private void enableMultipartFilter(HttpEndpoint endpoint, Server server, String connectorKey) throws Exception {
        Filter filter;
        ServletContextHandler context = (ServletContextHandler)server.getChildHandlerByClass(ServletContextHandler.class);
        CamelContext camelContext = this.getCamelContext();
        FilterHolder filterHolder = new FilterHolder();
        filterHolder.setInitParameter("deleteFiles", "true");
        if (ObjectHelper.isNotEmpty((Object)camelContext.getProperty(TMP_DIR))) {
            File file = new File(camelContext.getProperty(TMP_DIR));
            if (!file.isDirectory()) {
                throw new RuntimeCamelException("The temp file directory of camel-jetty is not exists, please recheck it with directory name :" + (String)camelContext.getProperties().get(TMP_DIR));
            }
            context.setAttribute("javax.servlet.context.tempdir", (Object)file);
        }
        if ((filter = ((JettyHttpEndpoint)endpoint).getMultipartFilter()) == null) {
            filter = new MultiPartFilter();
        }
        filterHolder.setFilter((Filter)new CamelFilterWrapper(filter));
        String pathSpec = endpoint.getPath();
        if (pathSpec == null || "".equals(pathSpec)) {
            pathSpec = "/";
        }
        if (endpoint.isMatchOnUriPrefix()) {
            pathSpec = pathSpec.endsWith("/") ? pathSpec + "*" : pathSpec + "/*";
        }
        this.addFilter(context, filterHolder, pathSpec);
        LOG.debug("using multipart filter implementation " + filter.getClass().getName() + " for path " + pathSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(HttpConsumer consumer) throws Exception {
        HttpEndpoint endpoint = consumer.getEndpoint();
        String connectorKey = this.getConnectorKey(endpoint);
        HashMap<String, ConnectorRef> hashMap = CONNECTORS;
        synchronized (hashMap) {
            ConnectorRef connectorRef = CONNECTORS.get(connectorKey);
            if (connectorRef != null) {
                connectorRef.servlet.disconnect(consumer);
                if (connectorRef.decrement() == 0) {
                    connectorRef.server.removeConnector(connectorRef.connector);
                    connectorRef.connector.stop();
                    connectorRef.server.stop();
                    CONNECTORS.remove(connectorKey);
                    if (this.mbContainer != null) {
                        this.removeServerMBean(connectorRef.server);
                    }
                }
            }
        }
    }

    private String getConnectorKey(HttpEndpoint endpoint) {
        return endpoint.getProtocol() + ":" + endpoint.getHttpUri().getHost() + ":" + endpoint.getPort();
    }

    public String getSslKeyPassword() {
        return this.sslKeyPassword;
    }

    public void setSslKeyPassword(String sslKeyPassword) {
        this.sslKeyPassword = sslKeyPassword;
    }

    public String getSslPassword() {
        return this.sslPassword;
    }

    public void setSslPassword(String sslPassword) {
        this.sslPassword = sslPassword;
    }

    public void setKeystore(String sslKeystore) {
        this.sslKeystore = sslKeystore;
    }

    public String getKeystore() {
        return this.sslKeystore;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    protected Connector getConnector(Server server, JettyHttpEndpoint endpoint) {
        Connector connector = "https".equals(endpoint.getProtocol()) ? this.getSslSocketConnector(server, endpoint) : this.getSocketConnector(server, endpoint);
        return connector;
    }

    protected Connector getSocketConnector(Server server, JettyHttpEndpoint endpoint) {
        Connector answer = null;
        if (this.socketConnectors != null) {
            answer = this.socketConnectors.get(endpoint.getPort());
        }
        if (answer == null) {
            answer = this.createConnector(server, endpoint);
        }
        return answer;
    }

    protected Connector getSslSocketConnector(Server server, JettyHttpEndpoint endpoint) {
        Connector answer = null;
        if (this.sslSocketConnectors != null) {
            answer = this.sslSocketConnectors.get(endpoint.getPort());
        }
        if (answer == null) {
            answer = this.createConnector(server, endpoint);
        }
        return answer;
    }

    protected Connector createConnector(Server server, JettyHttpEndpoint endpoint) {
        SslContextFactory sslcf = null;
        SSLContextParameters endpointSslContextParameters = endpoint.getSslContextParameters();
        if (endpointSslContextParameters != null) {
            try {
                sslcf = this.createSslContextFactory(endpointSslContextParameters);
            }
            catch (Exception e) {
                throw new RuntimeCamelException((Throwable)e);
            }
        } else if ("https".equals(endpoint.getProtocol())) {
            sslcf = new SslContextFactory();
            String keystoreProperty = System.getProperty(JETTY_SSL_KEYSTORE);
            if (keystoreProperty != null) {
                sslcf.setKeyStorePath(keystoreProperty);
            } else if (this.sslKeystore != null) {
                sslcf.setKeyStorePath(this.sslKeystore);
            }
            String keystorePassword = System.getProperty(JETTY_SSL_KEYPASSWORD);
            if (keystorePassword != null) {
                sslcf.setKeyManagerPassword(keystorePassword);
            } else if (this.sslKeyPassword != null) {
                sslcf.setKeyManagerPassword(this.sslKeyPassword);
            }
            String password = System.getProperty(JETTY_SSL_PASSWORD);
            if (password != null) {
                sslcf.setKeyStorePassword(password);
            } else if (this.sslPassword != null) {
                sslcf.setKeyStorePassword(this.sslPassword);
            }
        }
        return this.createConnectorJettyInternal(server, endpoint, sslcf);
    }

    protected abstract AbstractConnector createConnectorJettyInternal(Server var1, JettyHttpEndpoint var2, SslContextFactory var3);

    private SslContextFactory createSslContextFactory(SSLContextParameters ssl) throws GeneralSecurityException, IOException {
        SslContextFactory answer = new SslContextFactory();
        if (ssl != null) {
            answer.setSslContext(ssl.createSSLContext());
        }
        return answer;
    }

    protected boolean checkSSLContextFactoryConfig(Object instance) {
        try {
            Method method = instance.getClass().getMethod("checkConfig", new Class[0]);
            return (Boolean)method.invoke(instance, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return false;
    }

    public Map<Integer, Connector> getSslSocketConnectors() {
        return this.sslSocketConnectors;
    }

    public void setSslSocketConnectors(Map<Integer, Connector> connectors) {
        this.sslSocketConnectors = connectors;
    }

    public void setSocketConnectors(Map<Integer, Connector> socketConnectors) {
        this.socketConnectors = socketConnectors;
    }

    public CamelHttpClient createHttpClient(JettyHttpEndpoint endpoint, Integer minThreads, Integer maxThreads, SSLContextParameters ssl) throws Exception {
        int port;
        String host;
        SslContextFactory sslContextFactory = this.createSslContextFactory(ssl);
        CamelHttpClient httpClient = this.createCamelHttpClient(sslContextFactory);
        CamelContext context = endpoint.getCamelContext();
        if (context != null && ObjectHelper.isNotEmpty((Object)context.getProperty("http.proxyHost")) && ObjectHelper.isNotEmpty((Object)context.getProperty("http.proxyPort"))) {
            host = context.getProperty("http.proxyHost");
            port = Integer.parseInt(context.getProperty("http.proxyPort"));
            LOG.debug("CamelContext properties http.proxyHost and http.proxyPort detected. Using http proxy host: {} port: {}", (Object)host, (Object)port);
            httpClient.setProxy(host, port);
        }
        if (ObjectHelper.isNotEmpty((Object)endpoint.getProxyHost()) && endpoint.getProxyPort() > 0) {
            host = endpoint.getProxyHost();
            port = endpoint.getProxyPort();
            LOG.debug("proxyHost and proxyPort options detected. Using http proxy host: {} port: {}", (Object)host, (Object)port);
            httpClient.setProxy(host, port);
        }
        if (minThreads != null || maxThreads != null) {
            if (minThreads == null || maxThreads == null) {
                throw new IllegalArgumentException("Both min and max thread pool sizes must be provided.");
            }
            QueuedThreadPool qtp = new QueuedThreadPool();
            qtp.setMinThreads(minThreads.intValue());
            qtp.setMaxThreads(maxThreads.intValue());
            qtp.setDaemon(true);
            qtp.setName("CamelJettyClient(" + ObjectHelper.getIdentityHashCode((Object)((Object)httpClient)) + ")");
            httpClient.setThreadPoolOrExecutor((Executor)qtp);
        }
        if (LOG.isDebugEnabled()) {
            if (minThreads != null) {
                LOG.debug("Created HttpClient with thread pool {}-{} -> {}", new Object[]{minThreads, maxThreads, httpClient});
            } else {
                LOG.debug("Created HttpClient with default thread pool size -> {}", (Object)httpClient);
            }
        }
        return httpClient;
    }

    protected abstract CamelHttpClient createCamelHttpClient(SslContextFactory var1);

    public Integer getHttpClientMinThreads() {
        return this.httpClientMinThreads;
    }

    public void setHttpClientMinThreads(Integer httpClientMinThreads) {
        this.httpClientMinThreads = httpClientMinThreads;
    }

    public Integer getHttpClientMaxThreads() {
        return this.httpClientMaxThreads;
    }

    public void setHttpClientMaxThreads(Integer httpClientMaxThreads) {
        this.httpClientMaxThreads = httpClientMaxThreads;
    }

    public Integer getMinThreads() {
        return this.minThreads;
    }

    public void setMinThreads(Integer minThreads) {
        this.minThreads = minThreads;
    }

    public Integer getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(Integer maxThreads) {
        this.maxThreads = maxThreads;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public void setEnableJmx(boolean enableJmx) {
        this.enableJmx = enableJmx;
    }

    public boolean isEnableJmx() {
        return this.enableJmx;
    }

    public JettyHttpBinding getJettyHttpBinding() {
        return this.jettyHttpBinding;
    }

    public void setJettyHttpBinding(JettyHttpBinding jettyHttpBinding) {
        this.jettyHttpBinding = jettyHttpBinding;
    }

    public synchronized MBeanContainer getMbContainer() {
        if (this.mbContainer == null) {
            MBeanServer mbs = null;
            ManagementStrategy mStrategy = this.getCamelContext().getManagementStrategy();
            ManagementAgent mAgent = mStrategy.getManagementAgent();
            if (mAgent != null) {
                mbs = mAgent.getMBeanServer();
            }
            if (mbs != null) {
                this.mbContainer = new MBeanContainer(mbs);
                this.startMbContainer();
            } else {
                LOG.warn("JMX disabled in CamelContext. Jetty JMX extensions will remain disabled.");
            }
        }
        return this.mbContainer;
    }

    public void setMbContainer(MBeanContainer mbContainer) {
        this.mbContainer = mbContainer;
    }

    public Map<String, Object> getSslSocketConnectorProperties() {
        return this.sslSocketConnectorProperties;
    }

    public void setSslSocketConnectorProperties(Map<String, Object> sslSocketConnectorProperties) {
        this.sslSocketConnectorProperties = sslSocketConnectorProperties;
    }

    public Map<String, Object> getSocketConnectorProperties() {
        return this.socketConnectorProperties;
    }

    public void setSocketConnectorProperties(Map<String, Object> socketConnectorProperties) {
        this.socketConnectorProperties = socketConnectorProperties;
    }

    public void addSocketConnectorProperty(String key, Object value) {
        if (this.socketConnectorProperties == null) {
            this.socketConnectorProperties = new HashMap<String, Object>();
        }
        this.socketConnectorProperties.put(key, value);
    }

    public void addSslSocketConnectorProperty(String key, Object value) {
        if (this.sslSocketConnectorProperties == null) {
            this.sslSocketConnectorProperties = new HashMap<String, Object>();
        }
        this.sslSocketConnectorProperties.put(key, value);
    }

    public Long getContinuationTimeout() {
        return this.continuationTimeout;
    }

    public void setContinuationTimeout(Long continuationTimeout) {
        this.continuationTimeout = continuationTimeout;
    }

    public boolean isUseContinuation() {
        return this.useContinuation;
    }

    public void setUseContinuation(boolean useContinuation) {
        this.useContinuation = useContinuation;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public Integer getResponseBufferSize() {
        return this.responseBufferSize;
    }

    public void setResponseBufferSize(Integer responseBufferSize) {
        this.responseBufferSize = responseBufferSize;
    }

    public Integer getRequestBufferSize() {
        return this.requestBufferSize;
    }

    public void setRequestBufferSize(Integer requestBufferSize) {
        this.requestBufferSize = requestBufferSize;
    }

    public Integer getRequestHeaderSize() {
        return this.requestHeaderSize;
    }

    public void setRequestHeaderSize(Integer requestHeaderSize) {
        this.requestHeaderSize = requestHeaderSize;
    }

    public Integer getResponseHeaderSize() {
        return this.responseHeaderSize;
    }

    public void setResponseHeaderSize(Integer responseHeaderSize) {
        this.responseHeaderSize = responseHeaderSize;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public Consumer createConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, Map<String, Object> parameters) throws Exception {
        String path = basePath;
        if (uriTemplate != null) {
            path = uriTemplate.startsWith("/") ? path + uriTemplate : path + "/" + uriTemplate;
        }
        path = FileUtil.stripLeadingSeparator((String)path);
        String scheme = "http";
        String host = "";
        int port = 0;
        RestConfiguration config = camelContext.getRestConfiguration();
        if (config.getComponent() == null || config.getComponent().equals("jetty")) {
            int num;
            if (config.getScheme() != null) {
                scheme = config.getScheme();
            }
            if (config.getHost() != null) {
                host = config.getHost();
            }
            if ((num = config.getPort()) > 0) {
                port = num;
            }
        }
        if (ObjectHelper.isEmpty((Object)host)) {
            if (config.getRestHostNameResolver() == RestConfiguration.RestHostNameResolver.localHostName) {
                host = HostUtils.getLocalHostName();
            } else if (config.getRestHostNameResolver() == RestConfiguration.RestHostNameResolver.localIp) {
                host = HostUtils.getLocalIp();
            }
        }
        HashMap map = new HashMap();
        if (config != null && (config.getComponent() == null || config.getComponent().equals("jetty")) && config.getEndpointProperties() != null && !config.getEndpointProperties().isEmpty()) {
            map.putAll(config.getEndpointProperties());
        }
        String query = URISupport.createQueryString(map);
        String url = "jetty:%s://%s:%s/%s?httpMethodRestrict=%s";
        String restrict = verb.toUpperCase(Locale.US);
        url = String.format(url, scheme, host, port, path, restrict);
        if (!query.isEmpty()) {
            url = url + "&" + query;
        }
        JettyHttpEndpoint endpoint = (JettyHttpEndpoint)camelContext.getEndpoint(url, JettyHttpEndpoint.class);
        this.setProperties(camelContext, (Object)endpoint, parameters);
        endpoint.setEnableMultipartFilter(false);
        endpoint.setBinding((HttpBinding)new JettyRestHttpBinding(endpoint));
        Consumer consumer = endpoint.createConsumer(processor);
        if (config != null && config.getConsumerProperties() != null && !config.getConsumerProperties().isEmpty()) {
            this.setProperties(camelContext, consumer, config.getConsumerProperties());
        }
        return consumer;
    }

    protected CamelServlet createServletForConnector(Server server, Connector connector, List<Handler> handlers, JettyHttpEndpoint endpoint) throws Exception {
        CamelServlet camelServlet;
        boolean jetty;
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)server, "/", 0);
        if (Server.getVersion().startsWith("8")) {
            context.getClass().getMethod("setConnectorNames", String[].class).invoke((Object)context, new Object[]{new String[]{connector.getName()}});
        }
        this.addJettyHandlers(server, handlers);
        boolean bl = jetty = endpoint.getUseContinuation() != null ? endpoint.getUseContinuation().booleanValue() : this.isUseContinuation();
        if (jetty) {
            Long timeout;
            CamelContinuationServlet jettyServlet = new CamelContinuationServlet();
            Long l = timeout = endpoint.getContinuationTimeout() != null ? endpoint.getContinuationTimeout() : this.getContinuationTimeout();
            if (timeout != null) {
                LOG.info("Using Jetty continuation timeout: " + timeout + " millis for: " + (Object)((Object)endpoint));
                jettyServlet.setContinuationTimeout(timeout);
            } else {
                LOG.info("Using default Jetty continuation timeout for: " + (Object)((Object)endpoint));
            }
            camelServlet = jettyServlet;
        } else {
            camelServlet = new CamelServlet();
            LOG.info("Jetty continuation is disabled for: " + (Object)((Object)endpoint));
        }
        ServletHolder holder = new ServletHolder();
        holder.setServlet((Servlet)camelServlet);
        context.addServlet(holder, "/*");
        camelServlet.setServletResolveConsumerStrategy((ServletResolveConsumerStrategy)new JettyRestServletResolveConsumerStrategy());
        return camelServlet;
    }

    protected void addJettyHandlers(Server server, List<Handler> handlers) {
        if (handlers != null && !handlers.isEmpty()) {
            for (Handler handler : handlers) {
                if (handler instanceof HandlerWrapper) {
                    if (handler.equals(server.getHandler())) continue;
                    ((HandlerWrapper)handler).setHandler(server.getHandler());
                    server.setHandler(handler);
                    continue;
                }
                HandlerCollection handlerCollection = new HandlerCollection();
                handlerCollection.addHandler(server.getHandler());
                handlerCollection.addHandler(handler);
                server.setHandler((Handler)handlerCollection);
            }
        }
    }

    protected Server createServer() {
        Server s = null;
        ThreadPool tp = this.threadPool;
        QueuedThreadPool qtp = null;
        if (this.minThreads != null || this.maxThreads != null) {
            if (this.getThreadPool() != null) {
                throw new IllegalArgumentException("You cannot configure both minThreads/maxThreads and a custom threadPool on JettyHttpComponent: " + (Object)((Object)this));
            }
            qtp = new QueuedThreadPool();
            if (this.minThreads != null) {
                qtp.setMinThreads(this.minThreads.intValue());
            }
            if (this.maxThreads != null) {
                qtp.setMaxThreads(this.maxThreads.intValue());
            }
            tp = qtp;
        }
        if (tp != null) {
            try {
                if (!Server.getVersion().startsWith("8")) {
                    s = (Server)Server.class.getConstructor(ThreadPool.class).newInstance(tp);
                } else {
                    s = new Server();
                    Server.class.getMethod("setThreadPool", ThreadPool.class).invoke((Object)s, tp);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (s == null) {
            s = new Server();
        }
        if (qtp != null) {
            qtp.setName("CamelJettyServer(" + ObjectHelper.getIdentityHashCode((Object)s) + ")");
            try {
                qtp.start();
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Error starting JettyServer thread pool: " + qtp, (Throwable)e);
            }
        }
        ContextHandlerCollection collection = new ContextHandlerCollection();
        s.setHandler((Handler)collection);
        if (this.getErrorHandler() != null) {
            s.addBean((Object)this.getErrorHandler());
        } else if (!Server.getVersion().startsWith("8")) {
            ErrorHandler eh = new ErrorHandler(){

                public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
                    String msg = HttpStatus.getMessage((int)response.getStatus());
                    request.setAttribute("javax.servlet.error.message", (Object)msg);
                    if (response instanceof Response) {
                        ((Response)response).setStatus(response.getStatus(), msg);
                    }
                    super.handle(target, baseRequest, request, response);
                }

                protected void writeErrorPage(HttpServletRequest request, Writer writer, int code, String message, boolean showStacks) throws IOException {
                    super.writeErrorPage(request, writer, code, message, false);
                }
            };
            s.addBean((Object)eh);
        }
        return s;
    }

    protected void startMbContainer() {
        if (this.mbContainer != null && Server.getVersion().startsWith("8")) {
            try {
                boolean b = (Boolean)this.mbContainer.getClass().getMethod("isStarted", new Class[0]).invoke((Object)this.mbContainer, new Object[0]);
                if (b) {
                    this.mbContainer.getClass().getMethod("start", new Class[0]).invoke((Object)this.mbContainer, new Object[0]);
                    this.mbContainer.getClass().getMethod("addBean", Object.class).invoke((Object)this.mbContainer, this.mbContainer);
                }
            }
            catch (Throwable e) {
                LOG.warn("Could not start Jetty MBeanContainer. Jetty JMX extensions will remain disabled.", e);
            }
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.startMbContainer();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (CONNECTORS.size() > 0) {
            for (String connectorKey : CONNECTORS.keySet()) {
                ConnectorRef connectorRef = CONNECTORS.get(connectorKey);
                if (connectorRef == null || connectorRef.getRefCount() != 0) continue;
                connectorRef.server.removeConnector(connectorRef.connector);
                connectorRef.connector.stop();
                this.removeServerMBean(connectorRef.server);
                connectorRef.server.stop();
                CONNECTORS.remove(connectorKey);
            }
        }
        if (this.mbContainer != null) {
            try {
                this.mbContainer.getClass().getMethod("stop", new Class[0]).invoke((Object)this.mbContainer, new Object[0]);
            }
            catch (Throwable t) {
                this.mbContainer.getClass().getMethod("destroy", new Class[0]).invoke((Object)this.mbContainer, new Object[0]);
            }
            this.mbContainer = null;
        }
    }

    private void addServerMBean(Server server) {
        if (this.mbContainer == null) {
            return;
        }
        try {
            Container o = JettyHttpComponent.getContainer(server);
            o.getClass().getMethod("addEventListener", Container.Listener.class).invoke((Object)o, this.mbContainer);
            if (Server.getVersion().startsWith("8")) {
                return;
            }
            this.mbContainer.getClass().getMethod("beanAdded", Container.class, Object.class).invoke((Object)this.mbContainer, null, server);
        }
        catch (RuntimeException rex) {
            throw rex;
        }
        catch (Exception r) {
            throw new RuntimeException(r);
        }
    }

    private void removeServerMBean(Server server) {
        try {
            this.mbContainer.getClass().getMethod("beanRemoved", Container.class, Object.class).invoke((Object)this.mbContainer, null, server);
        }
        catch (RuntimeException rex) {
            throw rex;
        }
        catch (Exception r) {
            try {
                this.mbContainer.getClass().getMethod("removeBean", Object.class).invoke((Object)this.mbContainer, server);
            }
            catch (RuntimeException rex) {
                throw rex;
            }
            catch (Exception r2) {
                throw new RuntimeException(r);
            }
        }
    }

    private static Container getContainer(Object server) {
        if (server instanceof Container) {
            return (Container)server;
        }
        try {
            return (Container)server.getClass().getMethod("getContainer", new Class[0]).invoke(server, new Object[0]);
        }
        catch (RuntimeException t) {
            throw t;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    class ConnectorRef {
        Server server;
        Connector connector;
        CamelServlet servlet;
        int refCount;

        public ConnectorRef(Server server, Connector connector, CamelServlet servlet) {
            this.server = server;
            this.connector = connector;
            this.servlet = servlet;
            this.increment();
        }

        public int increment() {
            return ++this.refCount;
        }

        public int decrement() {
            return --this.refCount;
        }

        public int getRefCount() {
            return this.refCount;
        }
    }
}

