/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.component.http.HttpComponent;
import org.apache.camel.component.http.HttpConsumer;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.jetty.CamelHttpClient;
import org.apache.camel.component.jetty.DefaultJettyHttpBinding;
import org.apache.camel.component.jetty.JettyContentExchange;
import org.apache.camel.component.jetty.JettyHttpBinding;
import org.apache.camel.component.jetty.JettyHttpComponent;
import org.apache.camel.component.jetty.JettyHttpProducer;
import org.apache.camel.impl.SynchronousDelegateProducer;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.server.Handler;

public abstract class JettyHttpEndpoint
extends HttpEndpoint {
    private List<Handler> handlers;
    private HttpClient client;
    private Filter multipartFilter;
    private List<Filter> filters;
    private SSLContextParameters sslContextParameters;
    private Map<String, Object> httpClientParameters;
    private JettyHttpBinding jettyBinding;
    private HttpClient httpClient;
    @UriParam(label="consumer", description="Specifies whether to enable the session manager on the server side of Jetty.")
    private boolean sessionSupport;
    @UriParam(label="producer", defaultValue="8", description="To set a value for minimum number of threads in HttpClient thread pool. This setting override any setting configured on component level. Notice that both a min and max size must be configured. If not set it default to min 8 threads used in Jettys thread pool.")
    private Integer httpClientMinThreads;
    @UriParam(label="producer", defaultValue="254", description="To set a value for maximum number of threads in HttpClient thread pool. This setting override any setting configured on component level. Notice that both a min and max size must be configured. If not set it default to max 254 threads used in Jettys thread pool.")
    private Integer httpClientMaxThreads;
    @UriParam(label="consumer", description="If this option is true, Jetty JMX support will be enabled for this endpoint. See Jetty JMX support for more details.")
    private boolean enableJmx;
    @UriParam(description="Whether Jetty org.eclipse.jetty.servlets.MultiPartFilter is enabled or not. You should set this value to false when bridging endpoints, to ensure multipart requests is proxied/bridged as well.")
    private boolean enableMultipartFilter;
    @UriParam(label="consumer", defaultValue="true", description="If the option is true, jetty will send the server header with the jetty version information to the client which sends the request. NOTE please make sure there is no any other camel-jetty endpoint is share the same port, otherwise this option may not work as expected.")
    private boolean sendServerVersion = true;
    @UriParam(label="consumer", description="If the option is true, jetty server will send the date header to the client which sends the request. NOTE please make sure there is no any other camel-jetty endpoint is share the same port, otherwise this option may not work as expected.")
    private boolean sendDateHeader;
    @UriParam(label="consumer", defaultValue="30000", description="Allows to set a timeout in millis when using Jetty as consumer (server). By default Jetty uses 30000. You can use a value of <= 0 to never expire. If a timeout occurs then the request will be expired and Jetty will return back a http error 503 to the client. This option is only in use when using Jetty with the Asynchronous Routing Engine.")
    private Long continuationTimeout;
    @UriParam(label="consumer", description="Whether or not to use Jetty continuations for the Jetty Server.")
    private Boolean useContinuation;

    public JettyHttpEndpoint(JettyHttpComponent component, String uri, URI httpURL) throws URISyntaxException {
        super(uri, (HttpComponent)component, httpURL);
    }

    public JettyHttpComponent getComponent() {
        return (JettyHttpComponent)super.getComponent();
    }

    public Producer createProducer() throws Exception {
        JettyHttpProducer answer = new JettyHttpProducer((Endpoint)this);
        if (this.httpClient != null) {
            this.httpClient.start();
            answer.setSharedClient(this.httpClient);
            answer.setBinding(this.getJettyBinding(this.httpClient));
        } else {
            HttpClient httpClient = this.createJettyHttpClient();
            answer.setClient(httpClient);
            answer.setBinding(this.getJettyBinding(httpClient));
        }
        if (this.isSynchronous()) {
            return new SynchronousDelegateProducer((Producer)answer);
        }
        return answer;
    }

    protected HttpClient createJettyHttpClient() throws Exception {
        Integer min = this.httpClientMinThreads != null ? this.httpClientMinThreads : this.getComponent().getHttpClientMinThreads();
        Integer max = this.httpClientMaxThreads != null ? this.httpClientMaxThreads : this.getComponent().getHttpClientMaxThreads();
        CamelHttpClient httpClient = this.getComponent().createHttpClient(this, min, max, this.sslContextParameters);
        if (this.httpClientParameters != null) {
            HashMap<String, Object> params = new HashMap<String, Object>(this.httpClientParameters);
            params.remove("timeout");
            IntrospectionSupport.setProperties((Object)((Object)httpClient), params);
            if (params.size() > 0) {
                throw new ResolveEndpointFailedException(this.getEndpointUri(), "There are " + params.size() + " parameters that couldn't be set on the endpoint." + " Check the uri if the parameters are spelt correctly and that they are properties of the endpoint." + " Unknown parameters=[" + params + "]");
            }
        }
        return httpClient;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        HttpConsumer answer = new HttpConsumer((HttpEndpoint)this, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public void setSessionSupport(boolean support) {
        this.sessionSupport = support;
    }

    public boolean isSessionSupport() {
        return this.sessionSupport;
    }

    public List<Handler> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(List<Handler> handlers) {
        this.handlers = handlers;
    }

    public HttpClient getHttpClient() throws Exception {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public synchronized JettyHttpBinding getJettyBinding(HttpClient httpClient) {
        if (this.jettyBinding == null) {
            this.jettyBinding = new DefaultJettyHttpBinding();
            this.jettyBinding.setHeaderFilterStrategy(this.getHeaderFilterStrategy());
            this.jettyBinding.setThrowExceptionOnFailure(this.isThrowExceptionOnFailure());
            this.jettyBinding.setTransferException(this.isTransferException());
        }
        return this.jettyBinding;
    }

    public void setJettyBinding(JettyHttpBinding jettyBinding) {
        this.jettyBinding = jettyBinding;
    }

    public boolean isEnableJmx() {
        return this.enableJmx;
    }

    public void setEnableJmx(boolean enableJmx) {
        this.enableJmx = enableJmx;
    }

    public boolean isSendServerVersion() {
        return this.sendServerVersion;
    }

    public void setSendServerVersion(boolean sendServerVersion) {
        this.sendServerVersion = sendServerVersion;
    }

    public boolean isSendDateHeader() {
        return this.sendDateHeader;
    }

    public void setSendDateHeader(boolean sendDateHeader) {
        this.sendDateHeader = sendDateHeader;
    }

    public boolean isEnableMultipartFilter() {
        return this.enableMultipartFilter;
    }

    public void setEnableMultipartFilter(boolean enableMultipartFilter) {
        this.enableMultipartFilter = enableMultipartFilter;
    }

    public void setMultipartFilter(Filter filter) {
        this.multipartFilter = filter;
    }

    public Filter getMultipartFilter() {
        return this.multipartFilter;
    }

    public void setFilters(List<Filter> filterList) {
        this.filters = filterList;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public Long getContinuationTimeout() {
        return this.continuationTimeout;
    }

    public void setContinuationTimeout(Long continuationTimeout) {
        this.continuationTimeout = continuationTimeout;
    }

    public Boolean getUseContinuation() {
        return this.useContinuation;
    }

    public void setUseContinuation(Boolean useContinuation) {
        this.useContinuation = useContinuation;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public Integer getHttpClientMinThreads() {
        return this.httpClientMinThreads;
    }

    public void setHttpClientMinThreads(Integer httpClientMinThreads) {
        this.httpClientMinThreads = httpClientMinThreads;
    }

    public Integer getHttpClientMaxThreads() {
        return this.httpClientMaxThreads;
    }

    public void setHttpClientMaxThreads(Integer httpClientMaxThreads) {
        this.httpClientMaxThreads = httpClientMaxThreads;
    }

    public Map<String, Object> getHttpClientParameters() {
        return this.httpClientParameters;
    }

    public void setHttpClientParameters(Map<String, Object> httpClientParameters) {
        this.httpClientParameters = httpClientParameters;
    }

    public abstract JettyContentExchange createContentExchange();
}

