/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import org.apache.camel.Endpoint;
import org.apache.camel.component.http.CamelServlet;
import org.apache.camel.component.http.HttpComponent;
import org.apache.camel.component.http.HttpConsumer;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.http.HttpExchange;
import org.apache.camel.component.jetty.CamelContinuationServlet;
import org.apache.camel.component.jetty.JettyHttpEndpoint;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.client.HttpClient;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.security.SslSocketConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyHttpComponent
extends HttpComponent {
    private CamelServlet camelServlet;
    private Server server;
    private final HashMap<String, ConnectorRef> connectors = new HashMap();
    private HttpClient httpClient;
    private String sslKeyPassword;
    private String sslPassword;
    private String sslKeystore;
    private SslSocketConnector sslSocketConnector;

    protected Endpoint<HttpExchange> createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        URI httpURL = uri.startsWith("jetty:") ? new URI(remaining) : new URI(uri);
        return new JettyHttpEndpoint(this, uri, httpURL, this.getHttpConnectionManager());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(HttpConsumer consumer) throws Exception {
        HttpEndpoint endpoint = consumer.getEndpoint();
        String connectorKey = endpoint.getProtocol() + ":" + endpoint.getPort();
        HashMap<String, ConnectorRef> hashMap = this.connectors;
        synchronized (hashMap) {
            ConnectorRef connectorRef = this.connectors.get(connectorKey);
            if (connectorRef == null) {
                Object connector = "https".equals(endpoint.getProtocol()) ? this.getSslSocketConnector() : new SelectChannelConnector();
                connector.setPort(endpoint.getPort());
                this.getServer().addConnector((Connector)connector);
                connector.start();
                connectorRef = new ConnectorRef((Connector)connector);
                this.connectors.put(connectorKey, connectorRef);
            } else {
                connectorRef.increment();
            }
        }
        this.camelServlet.connect(consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(HttpConsumer consumer) throws Exception {
        this.camelServlet.disconnect(consumer);
        HttpEndpoint endpoint = consumer.getEndpoint();
        String connectorKey = endpoint.getProtocol() + ":" + endpoint.getPort();
        HashMap<String, ConnectorRef> hashMap = this.connectors;
        synchronized (hashMap) {
            ConnectorRef connectorRef = this.connectors.get(connectorKey);
            if (connectorRef != null && connectorRef.decrement() == 0) {
                this.getServer().removeConnector(connectorRef.connector);
                connectorRef.connector.stop();
                this.connectors.remove(connectorKey);
            }
        }
    }

    public Server getServer() throws Exception {
        if (this.server == null) {
            this.server = this.createServer();
        }
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public String getSslKeyPassword() {
        return this.sslKeyPassword;
    }

    public void setSslKeyPassword(String sslKeyPassword) {
        this.sslKeyPassword = sslKeyPassword;
    }

    public String getSslPassword() {
        return this.sslPassword;
    }

    public void setSslPassword(String sslPassword) {
        this.sslPassword = sslPassword;
    }

    public void setKeystore(String sslKeystore) {
        this.sslKeystore = sslKeystore;
    }

    public String getKeystore() {
        return this.sslKeystore;
    }

    public synchronized SslSocketConnector getSslSocketConnector() {
        if (this.sslSocketConnector == null) {
            this.sslSocketConnector = new SslSocketConnector();
            this.sslSocketConnector.setPassword(this.sslPassword);
            this.sslSocketConnector.setKeyPassword(this.sslKeyPassword);
            if (this.sslKeystore != null) {
                this.sslSocketConnector.setKeystore(this.sslKeystore);
            }
        }
        return this.sslSocketConnector;
    }

    public void setSslSocketConnector(SslSocketConnector connector) {
        this.sslSocketConnector = connector;
    }

    protected Server createServer() throws Exception {
        this.camelServlet = new CamelContinuationServlet();
        Server server = new Server();
        Context context = new Context(0);
        context.setContextPath("/");
        ServletHolder holder = new ServletHolder();
        holder.setServlet((Servlet)this.camelServlet);
        context.addServlet(holder, "/*");
        server.setHandler((Handler)context);
        server.start();
        return server;
    }

    protected void doStop() throws Exception {
        for (ConnectorRef connectorRef : this.connectors.values()) {
            connectorRef.connector.stop();
        }
        this.connectors.clear();
        if (this.server != null) {
            this.server.stop();
        }
        this.httpClient.stop();
        super.doStop();
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.httpClient == null) {
            this.httpClient = this.createHttpClient();
        }
        this.httpClient.start();
    }

    protected HttpClient createHttpClient() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.setConnectorType(2);
        httpClient.setMaxConnectionsPerAddress(2);
        return httpClient;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    class ConnectorRef {
        Connector connector;
        int refCount;

        public ConnectorRef(Connector connector) {
            this.connector = connector;
            this.increment();
        }

        public int increment() {
            return ++this.refCount;
        }

        public int decrement() {
            return --this.refCount;
        }
    }
}

