/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Producer;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.http.HttpExchange;
import org.apache.camel.component.jetty.JettyHttpComponent;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.mortbay.io.Buffer;
import org.mortbay.jetty.HttpFields;
import org.mortbay.jetty.HttpURI;
import org.mortbay.jetty.client.HttpClient;
import org.mortbay.jetty.client.HttpExchange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyHttpProducer
extends DefaultProducer<HttpExchange>
implements Producer<HttpExchange>,
AsyncProcessor {
    private HttpClient httpClient;
    private String address;

    public JettyHttpProducer(HttpEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.httpClient = ((JettyHttpComponent)endpoint.getComponent()).getHttpClient();
        this.address = endpoint.getHttpUri().toString();
        HttpURI uri = new HttpURI(this.address);
        if (uri.getCompletePath() == null) {
            this.address = this.address + "/";
        }
    }

    public void process(Exchange exchange) throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        this.process(exchange, new AsyncCallback(){

            public void done(boolean sync) {
                latch.countDown();
            }
        });
        latch.await();
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        CamelContentExchange jettyExchange = new CamelContentExchange(exchange, callback);
        jettyExchange.setURL(this.address);
        Message in = exchange.getIn();
        InputStream is = (InputStream)in.getBody(InputStream.class);
        if (is != null) {
            jettyExchange.setMethod("POST");
            jettyExchange.setRequestContentSource(is);
        } else {
            Buffer buffer = (Buffer)in.getBody(Buffer.class);
            if (buffer != null) {
                jettyExchange.setMethod("POST");
                jettyExchange.setRequestContent(buffer);
            } else {
                jettyExchange.setMethod("GET");
            }
        }
        HeaderFilterStrategy strategy = ((HttpEndpoint)this.getEndpoint()).getHeaderFilterStrategy();
        for (String name : in.getHeaders().keySet()) {
            String value = (String)in.getHeader(name, String.class);
            if ("Content-Type".equals(name)) {
                jettyExchange.setRequestContentType(value);
                continue;
            }
            if (strategy == null || strategy.applyFilterToCamelHeaders(name, (Object)value)) continue;
            jettyExchange.addRequestHeader(name, value);
        }
        try {
            this.httpClient.send((org.mortbay.jetty.client.HttpExchange)jettyExchange);
        }
        catch (IOException e) {
            exchange.setException((Throwable)e);
            return true;
        }
        return false;
    }

    private final class CamelContentExchange
    extends HttpExchange.ContentExchange {
        private final AsyncCallback callback;
        private final Exchange exchange;
        private HttpFields responseFields;

        private CamelContentExchange(Exchange exchange, AsyncCallback callback) {
            this.exchange = exchange;
            this.callback = callback;
            this.responseFields = new HttpFields();
        }

        protected void onResponseComplete() throws IOException {
            super.onRequestComplete();
            try {
                Message out = this.exchange.getOut(true);
                out.setBody((Object)this.getResponseContent());
                Iterator i = this.responseFields.getFields();
                while (i.hasNext()) {
                    HttpFields.Field field = (HttpFields.Field)i.next();
                    out.setHeader(field.getName(), (Object)field.getValue());
                }
            }
            catch (Throwable e) {
                this.exchange.setException(e);
            }
            this.callback.done(false);
        }

        public HttpFields getResponseFields() {
            return this.responseFields;
        }

        protected void onResponsetHeader(Buffer name, Buffer value) throws IOException {
            this.responseFields.add(name, value);
        }
    }
}

