/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.http.CamelServlet;
import org.apache.camel.component.http.HttpBinding;
import org.apache.camel.component.http.HttpComponent;
import org.apache.camel.component.http.HttpConsumer;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.http.HttpExchange;
import org.apache.camel.component.jetty.CamelContinuationServlet;
import org.apache.camel.component.jetty.JettyHttpEndpoint;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.URISupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.client.HttpClient;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.security.SslSocketConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.SessionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyHttpComponent
extends HttpComponent {
    private static final transient Log LOG = LogFactory.getLog(JettyHttpComponent.class);
    protected Server server;
    protected HashMap<String, ConnectorRef> connectors = new HashMap();
    protected HttpClient httpClient;
    protected String sslKeyPassword;
    protected String sslPassword;
    protected String sslKeystore;
    protected SslSocketConnector sslSocketConnector;

    protected Endpoint<HttpExchange> createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        String string = uri = uri.startsWith("jetty:") ? remaining : uri;
        if (this.httpClient == null) {
            this.httpClient = this.createHttpClient();
        }
        IntrospectionSupport.setProperties((Object)this.httpClient, (Map)parameters, (String)"httpClient.");
        String ref = (String)this.getAndRemoveParameter(parameters, "httpBindingRef", String.class);
        if (ref != null) {
            this.httpBinding = (HttpBinding)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)ref, HttpBinding.class);
        }
        URI httpUri = URISupport.createRemainingURI((URI)new URI(uri), (Map)parameters);
        uri = httpUri.toString();
        JettyHttpEndpoint result = new JettyHttpEndpoint(this, uri, httpUri, this.getHttpConnectionManager());
        if (this.httpBinding != null) {
            result.setBinding(this.httpBinding);
        }
        this.setProperties((Object)result, parameters);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(HttpConsumer consumer) throws Exception {
        JettyHttpEndpoint endpoint = (JettyHttpEndpoint)consumer.getEndpoint();
        String connectorKey = endpoint.getProtocol() + ":" + endpoint.getHttpUri().getHost() + ":" + endpoint.getPort();
        HashMap<String, ConnectorRef> hashMap = this.connectors;
        synchronized (hashMap) {
            ConnectorRef connectorRef = this.connectors.get(connectorKey);
            if (connectorRef == null) {
                Object connector = "https".equals(endpoint.getProtocol()) ? this.getSslSocketConnector() : new SelectChannelConnector();
                connector.setPort(endpoint.getPort());
                connector.setHost(endpoint.getHttpUri().getHost());
                if ("localhost".equalsIgnoreCase(endpoint.getHttpUri().getHost())) {
                    LOG.warn((Object)"You use localhost interface! It means that no external connections will be available. Don't you want to use 0.0.0.0 instead (all network interfaces)?");
                }
                this.getServer().addConnector((Connector)connector);
                connectorRef = new ConnectorRef((Connector)connector, this.createServletForConnector((Connector)connector));
                connector.start();
                this.connectors.put(connectorKey, connectorRef);
            } else {
                connectorRef.increment();
            }
            if (endpoint.isSessionSupport()) {
                this.enableSessionSupport();
            }
            connectorRef.servlet.connect(consumer);
        }
    }

    private void enableSessionSupport() throws Exception {
        Context context = (Context)this.getServer().getChildHandlerByClass(Context.class);
        if (context.getSessionHandler() == null) {
            SessionHandler sessionHandler = new SessionHandler();
            context.setSessionHandler(sessionHandler);
            if (context.isStarted()) {
                context.stop();
                context.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(HttpConsumer consumer) throws Exception {
        HttpEndpoint endpoint = consumer.getEndpoint();
        String connectorKey = endpoint.getProtocol() + ":" + endpoint.getPort();
        HashMap<String, ConnectorRef> hashMap = this.connectors;
        synchronized (hashMap) {
            ConnectorRef connectorRef = this.connectors.get(connectorKey);
            if (connectorRef != null) {
                connectorRef.servlet.disconnect(consumer);
                if (connectorRef.decrement() == 0) {
                    this.getServer().removeConnector(connectorRef.connector);
                    connectorRef.connector.stop();
                    this.connectors.remove(connectorKey);
                }
            }
        }
    }

    public Server getServer() throws Exception {
        if (this.server == null) {
            this.server = this.createServer();
        }
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public String getSslKeyPassword() {
        return this.sslKeyPassword;
    }

    public void setSslKeyPassword(String sslKeyPassword) {
        this.sslKeyPassword = sslKeyPassword;
    }

    public String getSslPassword() {
        return this.sslPassword;
    }

    public void setSslPassword(String sslPassword) {
        this.sslPassword = sslPassword;
    }

    public void setKeystore(String sslKeystore) {
        this.sslKeystore = sslKeystore;
    }

    public String getKeystore() {
        return this.sslKeystore;
    }

    public synchronized SslSocketConnector getSslSocketConnector() {
        if (this.sslSocketConnector == null) {
            this.sslSocketConnector = new SslSocketConnector();
            this.sslSocketConnector.setPassword(this.sslPassword);
            this.sslSocketConnector.setKeyPassword(this.sslKeyPassword);
            if (this.sslKeystore != null) {
                this.sslSocketConnector.setKeystore(this.sslKeystore);
            }
        }
        return this.sslSocketConnector;
    }

    public void setSslSocketConnector(SslSocketConnector connector) {
        this.sslSocketConnector = connector;
    }

    protected CamelServlet createServletForConnector(Connector connector) throws Exception {
        CamelContinuationServlet camelServlet = new CamelContinuationServlet();
        Context context = new Context((HandlerContainer)this.server, "/", 0);
        context.setConnectorNames(new String[]{connector.getName()});
        ServletHolder holder = new ServletHolder();
        holder.setServlet((Servlet)camelServlet);
        context.addServlet(holder, "/*");
        connector.start();
        context.start();
        return camelServlet;
    }

    protected Server createServer() throws Exception {
        Server server = new Server();
        ContextHandlerCollection collection = new ContextHandlerCollection();
        collection.setServer(server);
        server.addHandler((Handler)collection);
        server.start();
        return server;
    }

    protected void doStop() throws Exception {
        for (ConnectorRef connectorRef : this.connectors.values()) {
            connectorRef.connector.stop();
        }
        this.connectors.clear();
        if (this.server != null) {
            this.server.stop();
        }
        this.httpClient.stop();
        super.doStop();
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.httpClient == null) {
            this.httpClient = this.createHttpClient();
        }
        this.httpClient.start();
    }

    protected HttpClient createHttpClient() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.setConnectorType(2);
        httpClient.setMaxConnectionsPerAddress(2);
        return httpClient;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    class ConnectorRef {
        Connector connector;
        CamelServlet servlet;
        int refCount;

        public ConnectorRef(Connector connector, CamelServlet servlet) {
            this.connector = connector;
            this.servlet = servlet;
            this.increment();
        }

        public int increment() {
            return ++this.refCount;
        }

        public int decrement() {
            return --this.refCount;
        }
    }
}

