/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.http.HttpComponent;
import org.apache.camel.component.http.HttpConsumer;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.jetty.DefaultJettyHttpBinding;
import org.apache.camel.component.jetty.JettyHttpBinding;
import org.apache.camel.component.jetty.JettyHttpComponent;
import org.apache.camel.component.jetty.JettyHttpProducer;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.client.HttpClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyHttpEndpoint
extends HttpEndpoint {
    private boolean sessionSupport;
    private List<Handler> handlers;
    private HttpClient client;
    private JettyHttpBinding jettyBinding;

    public JettyHttpEndpoint(JettyHttpComponent component, String uri, URI httpURL) throws URISyntaxException {
        super(uri, (HttpComponent)component, httpURL);
    }

    public JettyHttpComponent getComponent() {
        return (JettyHttpComponent)super.getComponent();
    }

    public Producer createProducer() throws Exception {
        JettyHttpProducer answer = new JettyHttpProducer((Endpoint)this, this.getClient());
        answer.setBinding(this.getJettyBinding());
        return answer;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new HttpConsumer((HttpEndpoint)this, processor);
    }

    public void setSessionSupport(boolean support) {
        this.sessionSupport = support;
    }

    public boolean isSessionSupport() {
        return this.sessionSupport;
    }

    public List<Handler> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(List<Handler> handlers) {
        this.handlers = handlers;
    }

    public HttpClient getClient() {
        if (this.client == null) {
            return this.getComponent().getHttpClient();
        }
        return this.client;
    }

    public void setClient(HttpClient client) {
        this.client = client;
    }

    public synchronized JettyHttpBinding getJettyBinding() {
        if (this.jettyBinding == null) {
            this.jettyBinding = new DefaultJettyHttpBinding();
            this.jettyBinding.setHeaderFilterStrategy(this.getHeaderFilterStrategy());
            this.jettyBinding.setThrowExceptionOnFailure(this.isThrowExceptionOnFailure());
        }
        return this.jettyBinding;
    }

    public void setJettyBinding(JettyHttpBinding jettyBinding) {
        this.jettyBinding = jettyBinding;
    }
}

