/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.component.http.HttpComponent;
import org.apache.camel.component.http.HttpConsumer;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.jetty.CamelHttpClient;
import org.apache.camel.component.jetty.DefaultJettyHttpBinding;
import org.apache.camel.component.jetty.JettyHttpBinding;
import org.apache.camel.component.jetty.JettyHttpComponent;
import org.apache.camel.component.jetty.JettyHttpProducer;
import org.apache.camel.impl.SynchronousDelegateProducer;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.server.Handler;

public class JettyHttpEndpoint
extends HttpEndpoint {
    private boolean sessionSupport;
    private List<Handler> handlers;
    private HttpClient httpClient;
    private Integer httpClientMinThreads;
    private Integer httpClientMaxThreads;
    private JettyHttpBinding jettyBinding;
    private boolean enableJmx;
    private boolean enableMultipartFilter;
    private Filter multipartFilter;
    private List<Filter> filters;
    private Long continuationTimeout;
    private Boolean useContinuation;
    private SSLContextParameters sslContextParameters;
    private Map<String, Object> httpClientParameters;

    public JettyHttpEndpoint(JettyHttpComponent component, String uri, URI httpURL) throws URISyntaxException {
        super(uri, (HttpComponent)component, httpURL);
    }

    public JettyHttpComponent getComponent() {
        return (JettyHttpComponent)super.getComponent();
    }

    public Producer createProducer() throws Exception {
        JettyHttpProducer answer = new JettyHttpProducer((Endpoint)this);
        if (this.httpClient != null) {
            this.httpClient.start();
            answer.setSharedClient(this.httpClient);
        } else {
            Integer min = this.httpClientMinThreads != null ? this.httpClientMinThreads : this.getComponent().getHttpClientMinThreads();
            Integer max = this.httpClientMaxThreads != null ? this.httpClientMaxThreads : this.getComponent().getHttpClientMaxThreads();
            CamelHttpClient httpClient = this.getComponent().createHttpClient(this, min, max, this.sslContextParameters);
            if (this.httpClientParameters != null) {
                HashMap<String, Object> params = new HashMap<String, Object>(this.httpClientParameters);
                IntrospectionSupport.setProperties((Object)((Object)httpClient), params);
                if (params.size() > 0) {
                    throw new ResolveEndpointFailedException(this.getEndpointUri(), "There are " + params.size() + " parameters that couldn't be set on the endpoint." + " Check the uri if the parameters are spelt correctly and that they are properties of the endpoint." + " Unknown parameters=[" + params + "]");
                }
            }
            answer.setClient(httpClient);
        }
        answer.setBinding(this.getJettyBinding());
        if (this.isSynchronous()) {
            return new SynchronousDelegateProducer((Producer)answer);
        }
        return answer;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        HttpConsumer answer = new HttpConsumer((HttpEndpoint)this, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public void setSessionSupport(boolean support) {
        this.sessionSupport = support;
    }

    public boolean isSessionSupport() {
        return this.sessionSupport;
    }

    public List<Handler> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(List<Handler> handlers) {
        this.handlers = handlers;
    }

    public HttpClient getHttpClient() throws Exception {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public synchronized JettyHttpBinding getJettyBinding() {
        if (this.jettyBinding == null) {
            this.jettyBinding = new DefaultJettyHttpBinding();
            this.jettyBinding.setHeaderFilterStrategy(this.getHeaderFilterStrategy());
            this.jettyBinding.setThrowExceptionOnFailure(this.isThrowExceptionOnFailure());
            this.jettyBinding.setTransferException(this.isTransferException());
        }
        return this.jettyBinding;
    }

    public void setJettyBinding(JettyHttpBinding jettyBinding) {
        this.jettyBinding = jettyBinding;
    }

    public boolean isEnableJmx() {
        return this.enableJmx;
    }

    public void setEnableJmx(boolean enableJmx) {
        this.enableJmx = enableJmx;
    }

    public boolean isEnableMultipartFilter() {
        return this.enableMultipartFilter;
    }

    public void setEnableMultipartFilter(boolean enableMultipartFilter) {
        this.enableMultipartFilter = enableMultipartFilter;
    }

    public void setMultipartFilter(Filter filter) {
        this.multipartFilter = filter;
    }

    public Filter getMultipartFilter() {
        return this.multipartFilter;
    }

    public void setFilters(List<Filter> filterList) {
        this.filters = filterList;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public Long getContinuationTimeout() {
        return this.continuationTimeout;
    }

    public void setContinuationTimeout(Long continuationTimeout) {
        this.continuationTimeout = continuationTimeout;
    }

    public Boolean getUseContinuation() {
        return this.useContinuation;
    }

    public void setUseContinuation(Boolean useContinuation) {
        this.useContinuation = useContinuation;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public Integer getHttpClientMinThreads() {
        return this.httpClientMinThreads;
    }

    public void setHttpClientMinThreads(Integer httpClientMinThreads) {
        this.httpClientMinThreads = httpClientMinThreads;
    }

    public Integer getHttpClientMaxThreads() {
        return this.httpClientMaxThreads;
    }

    public void setHttpClientMaxThreads(Integer httpClientMaxThreads) {
        this.httpClientMaxThreads = httpClientMaxThreads;
    }

    public Map<String, Object> getHttpClientParameters() {
        return this.httpClientParameters;
    }

    public void setHttpClientParameters(Map<String, Object> httpClientParameters) {
        this.httpClientParameters = httpClientParameters;
    }
}

