/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty9;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.apache.camel.component.http.DefaultHttpBinding;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.http.HttpMessage;
import org.eclipse.jetty.util.MultiPartInputStreamParser;

final class AttachmentHttpBinding
extends DefaultHttpBinding {
    AttachmentHttpBinding(HttpEndpoint endpoint) {
        super(endpoint);
    }

    protected void populateAttachments(HttpServletRequest request, HttpMessage message) {
        Object object = request.getAttribute("org.eclipse.jetty.servlet.MultiPartFile.multiPartInputStream");
        if (object instanceof MultiPartInputStreamParser) {
            MultiPartInputStreamParser parser = (MultiPartInputStreamParser)object;
            try {
                Collection parts = parser.getParts();
                for (Part part : parts) {
                    String contentType = part.getContentType();
                    if (!contentType.startsWith("application/octet-stream")) continue;
                    PartDataSource ds = new PartDataSource(part);
                    message.addAttachment(part.getName(), new DataHandler((DataSource)ds));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    final class PartDataSource
    implements DataSource {
        private final Part part;

        PartDataSource(Part part) {
            this.part = part;
        }

        public OutputStream getOutputStream() throws IOException {
            return null;
        }

        public String getName() {
            return this.part.getName();
        }

        public InputStream getInputStream() throws IOException {
            return this.part.getInputStream();
        }

        public String getContentType() {
            return this.part.getContentType();
        }
    }
}

